O /*****************************************************************************/  /*+                                   (w)util.c    Module name says it all.    	 COPYRIGHT 	 --------- % Copyright (C) 2020-2025 Mark G.Daniel / This program comes with ABSOLUTELY NO WARRANTY. G This is free software, and you are welcome to redistribute it under the N conditions of the GNU GENERAL PUBLIC LICENSE, version 3, or any later version.# http://www.gnu.org/licenses/gpl.txt      VERSION HISTORY  --------------- > 20-APR-2021  MGD  rework doasprintf(), asprintf(), vasprintf()2 10-DEC-2019  MGD  initial (transplanted from WCME) */O /*****************************************************************************/    #include <ctype.h> #include <errno.h> #include <stat.h>  #include <stdarg.h>  #include <stdlib.h>  #include <stdio.h> #include <string.h>  #include <time.h>  #include <types.h> #include <unistd.h>  #include <unixlib.h>   #include <descrip.h> #include <jpidef.h>  #include <lib$routines.h>  #include <lnmdef.h>  #include <prvdef.h>  #include <ssdef.h> #include <stsdef.h>  #include <starlet.h>   #include "wucme.h"   #define FI_LI "UTIL", __LINE__  O /*****************************************************************************/  /*0 Enable SYSPRV and SYSLCK in the calling process.? If the image is INSTALLed with SETPRV then enable that as well.  */   void UtilAdjustPriv ()   { ?    static ulong  ResetPrvMask [2] = { 0xffffffff, 0xffffffff }; D    static ulong  AdjustPrvMask [2] = { PRV$M_NETMBX | PRV$M_TMPMBX |I                                         PRV$M_SYSLCK | PRV$M_SYSPRV, 0 }; <    static ulong  AdjustSetPrvMask [2] = { PRV$M_SETPRV, 0 };      int  status;       /*********/    /* begin */    /*********/  #    /* first reset all privileges */ 0    status = sys$setprv (0, &ResetPrvMask, 0, 0);+    if (!(status && 1)) EXIT_FI_LI (status);   %    /* then set required privileges */ 1    status = sys$setprv (1, &AdjustPrvMask, 0, 0);      if (status == SS$_NOTALLPRIV)    {L       if (wucmeMode(IS_WASD) || wucmeMode(IS_APACHE)) ScriptStreamHeader ();R       fputs ("%WUCME-F-NOPRIV, must be INSTALLed with SYSPRV and SYSLCK", stdout);*       exit (SS$_NOPRIV | STS$M_INHIB_MSG);    }*    if (!(status & 1)) EXIT_FI_LI (status);  6    /* if NOT installed with SETPRV then just ignore */+    sys$setprv (1, &AdjustSetPrvMask, 0, 0);  }   O /*****************************************************************************/  /* Rude and crude (but works).  */  " char* doasprintf (char *fmt, ...)  {     int  cnt;    char  *cptr;     va_list  aptr;       va_start(aptr, fmt); 3    cnt = vasprintf (&cptr, (const char*)fmt, aptr);     va_end(aptr);  "    return (cnt < 0 ? NULL : cptr); }   O /*****************************************************************************/  /*+ Return a pointer to an equivalent VMS name. A Calling code must cast return value using (char*) and type as -1. & Also acts as its own callback routine. */   int UtilVmsName  (  char *name,  int type )  {     static char  *vname;       /*********/    /* begin */    /*********/      if (type == -1)      {5       if (decc$to_vms (name, UtilVmsName, 0, 0) != 1)        { !          if (vname) free (vname);           vname = NULL;       }        return ((int)vname);    }      if (vname) free (vname);   "    if (type == DECC$K_DIRECTORY ||        type == DECC$K_FOREIGN)      {       vname = NULL;        return (0);     }      vname = strdup(name);    return (1);   }   O /*****************************************************************************/  /* Allowed to use the application?  */   int UtilHaveSysPrv (void)  { 5    static ulong  SysPrvMask[2] = { PRV$M_SYSPRV, 0 };   %    return (UtilHavePriv(SysPrvMask));  }   O /*****************************************************************************/  /*, Check privilege mask.  Return true or false. */  " int UtilHavePriv (ulong *PrivMask) { !    static ulong  JpiImagPriv [2], !                  JpiProcPriv [2];       static struct {       short int  buf_len;        short int  item;       void  *buf_addr;       ushort  *ret_len;     } JpiItemList[] =      {?        { sizeof(JpiImagPriv), JPI$_IMAGPRIV, &JpiImagPriv, 0 }, ?        { sizeof(JpiProcPriv), JPI$_PROCPRIV, &JpiProcPriv, 0 },         {0,0,0,0}    };       int  status;       /*********/    /* begin */    /*********/  9    status = sys$getjpiw (0, 0, 0, &JpiItemList, 0, 0, 0);   .    if ((status & 1) == 0) EXIT_FI_LI (status);  >    return ((((JpiImagPriv[0] & PrivMask[0]) == PrivMask[0]) &&?             ((JpiImagPriv[1] & PrivMask[1]) == PrivMask[1])) || >            (((JpiProcPriv[0] & PrivMask[0]) == PrivMask[0]) &&>             ((JpiProcPriv[1] & PrivMask[1]) == PrivMask[1]))); }   O /*****************************************************************************/  /*E If |name| not NULL sets the process name.  Return NULL if this fails. H Always returns a pointer to the significant portion of the process name. */   char* UtilSetPrn (char *name)    {     static char  *NamePtr = "";    static char  prcnam [16];      char  *cptr, *sptr, *zptr; (    $DESCRIPTOR (NameDsc, (char*)prcnam);      /*********/    /* begin */    /*********/      if (!name) return (NamePtr);   -    zptr = (sptr = prcnam) + sizeof(prcnam)-1; >    for (cptr = name; *cptr && sptr < zptr; *sptr++ = *cptr++);    *sptr = '\0';(    NameDsc.dsc$w_length = sptr - prcnam;
    if (*name) '       if (!(sys$setprn (&NameDsc) & 1))           return (NULL);     return (NamePtr); }   O /*****************************************************************************/  /* Return the process name. */   char* UtilGetPrcNam (void)   {     static short  PrcNamLength;(    static unsigned char  JpiPrcNam [16];    static struct    {       unsigned short  buf_len;       unsigned short  item;        unsigned char  *buf_addr;        void  *ret_len;     }    JpiItems [] =    {D      { sizeof(JpiPrcNam)-1, JPI$_PRCNAM, JpiPrcNam, &PrcNamLength },      { 0,0,0,0 }    };       int  status;     char  *cptr;       /*********/    /* begin */    /*********/  6    status = sys$getjpiw (0, 0, 0, &JpiItems, 0, 0, 0);$    if (!(status & 1)) exit (status);  "    JpiPrcNam[PrcNamLength] = '\0';    return ((char*)JpiPrcNam);  }   O /*****************************************************************************/  /* Return the PID.  */   long UtilGetPid (void)   {     static long JpiPid;    static struct    {       unsigned short  buf_len;       unsigned short  item;        void  *buf_addr;       void  *ret_len;     }    JpiItems [] =    {.      { sizeof(JpiPid), JPI$_PID, &JpiPid, 0 },      { 0,0,0,0 }    };       int  status;       /*********/    /* begin */    /*********/  6    status = sys$getjpiw (0, 0, 0, &JpiItems, 0, 0, 0);$    if (!(status & 1)) exit (status);      return (JpiPid);  }   O /*****************************************************************************/  /* Divine our image name. */   char* UtilImageName (void)   { "    static char  JpiImagName [256];    static struct    {       ushort  buf_len;       ushort  item;        uchar   *buf_addr;       ushort  *short_ret_len;     } JpiItems [] =    {F       { sizeof(JpiImagName), JPI$_IMAGNAME, (uchar*)&JpiImagName, 0 },       { 0,0,0,0 }     };       int  status;     char  *cptr;       /*********/    /* begin */    /*********/  ,    if (JpiImagName[0]) return (JpiImagName);  6    status = sys$getjpiw (0, 0, 0, &JpiItems, 0, 0, 0);.    if ((status & 1) == 0) EXIT_FI_LI (status);  A    /* when fork()ing ensure we're not using a specific version */ ;    for (cptr = JpiImagName; *cptr && *cptr != ';'; cptr++); "    if (*cptr == ';') *cptr = '\0';      return (JpiImagName); }   O /*****************************************************************************/  /*K Return a pointer to a static buffer containing the string equivalent of the  supplied VMS status value. */   char* UtilGetMsg (int status)  {     static char  buf [256];      unsigned short  slen;    $DESCRIPTOR (bufDsc, buf);       /*********/    /* begin */    /*********/  -    sys$getmsg (status, &slen, &bufDsc, 1, 0);     buf[slen] = '\0';    buf[0] = toupper(buf[0]);    return (buf); }   O /*****************************************************************************/  /* Just a wrapper.  */   char* UtilSysTrnLnm (char *lnm)  { .    return (UtilTrnLnm (lnm, "LNM$SYSTEM", 0)); }   O /*****************************************************************************/  /*L Translate a logical name using LNM$FILE_DEV by default or the specified nameK table.  Returns a pointer to the value string, or NULL if the name does not L exist.  'IndexValue' should be zero for a 'flat' logical name, or 0..127 forN interative translations.  Returns pointer to non-reentrant static buffer which must be strdup()ed if retained.  */   char* UtilTrnLnm (  char *LogName, char *LogTable,  int IndexValue )  {     static ushort  ValueLength;    static ulong  LnmAttributes,                   LnmIndex;    static char  LogValue [256]; '    static $DESCRIPTOR (LogNameDsc, ""); (    static $DESCRIPTOR (LogTableDsc, "");    static struct {       short int  buf_len;        short int  item;       void  *buf_addr;       ushort  *ret_len;     } LnmItems [] =    {5       { sizeof(LnmIndex), LNM$_INDEX, &LnmIndex, 0 }, D       { sizeof(LnmAttributes), LNM$_ATTRIBUTES, &LnmAttributes, 0 },@       { sizeof(LogValue), LNM$_STRING, LogValue, &ValueLength },       { 0,0,0,0 }     };       int  status;       /*********/    /* begin */    /*********/      LnmIndex = IndexValue;       if (LogTable)    {+       LogTableDsc.dsc$a_pointer = LogTable; 2       LogTableDsc.dsc$w_length = strlen(LogTable);    }    else     {1       LogTableDsc.dsc$a_pointer = "LNM$FILE_DEV"; :       LogTableDsc.dsc$w_length = sizeof("LNM$FILE_DEV")-1;    }  &    LogNameDsc.dsc$a_pointer = LogName;-    LogNameDsc.dsc$w_length = strlen(LogName);   D    status = sys$trnlnm (0, &LogTableDsc, &LogNameDsc, 0, &LnmItems);8    if (!(status & 1) || !(LnmAttributes & LNM$M_EXISTS))    {'       if (LogValue) LogValue[0] = '\0';        return (NULL);    }       LogValue[ValueLength] = '\0';    return (LogValue);  }   O /*****************************************************************************/  /** Create a logical name in the SYSTEM table. */   void UtilSysCreLnm (  char *name,  char *value  )  { '    static $DESCRIPTOR (LogNameDsc, ""); 2    static $DESCRIPTOR (LogTableDsc, "LNM$SYSTEM");    static struct {       short int  buf_len;        short int  item;        unsigned char   *buf_addr;       unsigned short  *ret_len;     } CreLnmItem [2];      int  status;       /*********/    /* begin */    /*********/  #    LogNameDsc.dsc$a_pointer = name; *    LogNameDsc.dsc$w_length = strlen(name);  $    CreLnmItem[0].item = LNM$_STRING;*    CreLnmItem[0].buf_addr = (uchar*)value;)    CreLnmItem[0].buf_len = strlen(value);   F    status = sys$crelnm (0, &LogTableDsc, &LogNameDsc, 0, &CreLnmItem);*    if (!(status & 1)) EXIT_FI_LI (status); }   O /*****************************************************************************/  /* */   /*=  * Copyright (c) 1995, 1996, 1997 Kungliga Tekniska Hgskolan 6  * (Royal Institute of Technology, Stockholm, Sweden).  * All rights reserved.  */  % errx (int eval, const char *fmt, ...)  { 
   va_list ap;    va_start(ap, fmt);   verrx(eval, fmt, ap); 
   va_end(ap);  }   - verrx (int eval, const char *fmt, va_list ap)  {      rk_warnerr(0, fmt, ap);      exit(eval);  }   O /*****************************************************************************/  /*7  * Find the first occurrence of find in s, ignore case.   */  char *+ strcasestr(const char *s, const char *find)  {          char c, sc;          size_t len; !         if ((c = *find++) != 0) { 4                 c = (char)tolower((unsigned char)c);#                 len = strlen(find);                  do {                         do {5                                 if ((sc = *s++) == 0) 6                                         return (NULL);H                         } while ((char)tolower((unsigned char)sc) != c);9                 } while (strncasecmp(s, find, len) != 0);                  s--;	         }          return ((char *)s);  }   O /*****************************************************************************/  /* */   int wucme_asprintf (  char **sptr, const char *fmt, ...  )  {     int  cnt;    va_list  aptr;     char buf [8192];       va_start(aptr, fmt); 1    cnt = vsnprintf (buf, sizeof(buf), fmt, aptr); -    if (cnt >= 0 && sptr) *sptr = strdup(buf);     va_end(aptr);    return (cnt); }   O /*****************************************************************************/  /* Rude and crude (but works).  */   int wucme_vasprintf  (  char **sptr, const char *fmt, va_list aptr )  {     int cnt;     char buf [8192]; 1    cnt = vsnprintf (buf, sizeof(buf), fmt, aptr); -    if (cnt >= 0 && sptr) *sptr = strdup(buf);     return (cnt); }   O /*****************************************************************************/  /*  * Copyright (c) 1988, 1993 L  *        The Regents of the University of California.  All rights reserved. */   char *( wucme_strndup(const char *str, size_t n) {          size_t len;          char *copy;            len = strnlen(str, n);-         if ((copy = malloc(len + 1)) == NULL)                  return (NULL);         memcpy(copy, str, len);          copy[len] = '\0';          return (copy); }   O /*****************************************************************************/  /* */   /*=  * Copyright (c) 1995, 1996, 1997 Kungliga Tekniska Hgskolan 6  * (Royal Institute of Technology, Stockholm, Sweden).  * All rights reserved.  */   void warn(const char *fmt, ...) {     va_list ap;    va_start(ap, fmt);     vwarn(fmt, ap);    va_end(ap); }    void warnx(const char *fmt, ...)  {     va_list ap;    va_start(ap, fmt);     vwarnx(fmt, ap);     va_end(ap); }   ' void vwarn(const char *fmt, va_list ap)  {      rk_warnerr(1, fmt, ap);  }   ( void vwarnx(const char *fmt, va_list ap) {      rk_warnerr(0, fmt, ap);  }   : void rk_warnerr (int doerrno, const char *fmt, va_list ap) {      int sverrno = errno; #ifdef IS_WUCME (     const char *progname = tstamp(NULL); #else )     const char *progname = getprogname();  #endif       if(progname != NULL){ (         fprintf(stderr, "%s", progname);"         if(fmt != NULL || doerrno)"             fprintf(stderr, ": ");     }      if (fmt != NULL){ "         vfprintf(stderr, fmt, ap);         if(doerrno) "             fprintf(stderr, ": ");     }      if(doerrno) 1         fprintf(stderr, "%s", strerror(sverrno));      fprintf(stderr, "\n");     fflush(stderr);  }   O /*****************************************************************************/  /*O Return a pointer to string time-stamp "yyyy-mm-dd-hh:mm:ss.hh".  Not reentrant.  */   char* tstamp (ulong *binptr)   {     static char  stamp [32];       ulong  BinTime [2];    ushort  NumTime [7];       /*********/    /* begin */    /*********/  7    if (!binptr) sys$gettim (binptr = (ulong*)&BinTime); !    sys$numtim (&NumTime, binptr); M    sprintf (stamp, "%04.04d-%02.02d-%02.02d %02.02d:%02.02d:%02.02d.%02.02d", 6                    NumTime[0], NumTime[1], NumTime[2],C                    NumTime[3], NumTime[4], NumTime[5], NumTime[6]);     return (stamp); }   O /*****************************************************************************/  /*I Return a pointer to string time-stamp "yyyymmddhhmmsshh".  Not reentrant.  */   char* tstamp2 (ulong *binptr)    {     static char  stamp [32];       ulong  BinTime [2];    ushort  NumTime [7];       /*********/    /* begin */    /*********/  7    if (!binptr) sys$gettim (binptr = (ulong*)&BinTime); !    sys$numtim (&NumTime, binptr); G    sprintf (stamp, "%04.04d%02.02d%02.02d%02.02d%02.02d%02.02d%02.02d", 6                    NumTime[0], NumTime[1], NumTime[2],C                    NumTime[3], NumTime[4], NumTime[5], NumTime[6]);     return (stamp); }   O /*****************************************************************************/  /*K Just continue, to report an error if the image couldn't be activated or the  required symbol not found. */   int ApacheSetSockOptHandler ()   {     /*********/    /* begin */    /*********/      return (SS$_CONTINUE);  }   O /*****************************************************************************/  /*6 Set the Apache <stdout> stream is back to record mode. */   void ApacheExitRecordMode ()   {     /*********/    /* begin */    /*********/      fflush (stdout);     ApacheSetSockOpt(1);  }   O /*****************************************************************************/  /*# (The equivalent of apache$set_ccl.)   L For SWS version 2.0!  Based on information provided in private communicationM with Richard Barry (thanks Rick) this function calls the apache$$setsockopt() J function to adjust the BG device's characteristics suitable for binary andM record output.  To select binary mode call with a parameter of 0, record mode L with 1, toggle the modes with -1, and set the BG device buffer size with any7 value greater than 255 and less than or equal to 65535.   H This is based on a function description provided by Rick, but makes the K sharable image activation and symbol resolution dynamic to allow the object L module to be linked on systems without VMS Apache and/or the APACHE$APR_SHRP shareable image available. */  ' void ApacheSetSockOpt (int OptionValue)    {  #define OPT_CCLBIT    1  #define OPT_BUFSIZ    2  #define OPT_SHAREABLE 3   #define LIB$M_FIS_MIXEDCASE 0x10      static int  IsBin; +    static unsigned short  SysOutputChannel; B    static int (*ApacheSetSockOpt)(unsigned short, int, int*, int);  3    static $DESCRIPTOR (StdOutputDsc, "SYS$OUTPUT"); A    static $DESCRIPTOR (ApacheAprShrpImageDsc, "APACHE$APR_SHRP"); E    static $DESCRIPTOR (HpeApacheSetSockOptDsc, "APACHE$$SETSOCKOPT"); B    static $DESCRIPTOR (VsiApacheSetSockOptDsc, "apr$$setsockopt");      int  dbug, status;     char  *aptr;       /*********/    /* begin */    /*********/  7    if (dbug = (UtilSysTrnLnm ("WUCME_APACHE") != NULL))     {;       fprintf (stdout, "Content-Type: text/plain\r\n\r\n"); ?       fprintf (stdout, "ApacheSetSockOpt() %d\n", OptionValue);     }      if (SysOutputChannel)       status = SS$_NORMAL;    else     {0       /* first look for the VSI Apache symbol */2       aptr = VsiApacheSetSockOptDsc.dsc$a_pointer;.       lib$establish (ApacheSetSockOptHandler);=       status = lib$find_image_symbol (&ApacheAprShrpImageDsc, >                                       &VsiApacheSetSockOptDsc,;                                       &ApacheSetSockOpt, 0, ;                                       LIB$M_FIS_MIXEDCASE);        if (dbug) J          fprintf (stdout, "lib$find_image_symbol() %%X%08.08X\n", status);       lib$revert ();       if (!(status & 1))       { 6          /* second look for the HP(E) Apache symbol */5          aptr = HpeApacheSetSockOptDsc.dsc$a_pointer; 1          lib$establish (ApacheSetSockOptHandler); @          status = lib$find_image_symbol (&ApacheAprShrpImageDsc,A                                          &HpeApacheSetSockOptDsc, B                                          &ApacheSetSockOpt, 0, 0);          if (dbug)M             fprintf (stdout, "lib$find_image_symbol() %%X%08.08X\n", status);           lib$revert ();        }        if (status & 1)        { F          status = sys$assign (&StdOutputDsc, &SysOutputChannel, 0, 0);I          if (dbug) fprintf (stdout, "sys$assign() %%X%08.08X\n", status); (          atexit (&ApacheExitRecordMode);       }     }      if (status & 1)    {       if (OptionValue > 255)B          status = ApacheSetSockOpt (SysOutputChannel, OPT_BUFSIZ, G                                     &OptionValue, sizeof(OptionValue)); 
       elseB          status = ApacheSetSockOpt (SysOutputChannel, OPT_CCLBIT, G                                     &OptionValue, sizeof(OptionValue)); L       if (dbug) fprintf (stdout, "ApacheSetSockOpt() %%X%08.08X\n", status);    }      if (status & 1) return;      exit (status);  }   O /*****************************************************************************/   