$!-----------------------------------------------------------------'f$verify(0)
$! SSL_DETECT.COM
$!
$! Copyright (C) 1996-2025 Mark G.Daniel.
$!
$! Licensed under the Apache License, Version 2.0 (the "License");
$! you may not use this file except in compliance with the License.
$! You may obtain a copy of the License at
$!
$!    http://www.apache.org/licenses/LICENSE-2.0
$!
$! Unless required by applicable law or agreed to in writing, software
$! distributed under the License is distributed on an "AS IS" BASIS,
$! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
$! See the License for the specific language governing permissions and
$! limitations under the License.
$!
$! Checks for and determines which OpenSSL toolkit will be built against.
$!
$! The latest VSI OpenSSL kits should be fine for pre-V8.4 systems.
$! Prompt VSI attention to OpenSSL releases reduces the need for
$! WASD-specific OpenSSL builds so these will no longer be released.
$!
$!   https://wasd.vsm.com.au/info-WASD/2022/0070
$!
$! 14-DEC-2024  MGD  restrict OpenSSL versions by listing them in P1
$! 07-JAN-2024  MGD  VSI OpenSSL kits should be fine for pre-V8.4 systems
$!                   remove WASD SSL packages (obsolete)
$! 22-FEB-2022  MGD  refactor TLS/SSL build
$!                   VSI SSL3
$! 19-JAN-2020  MGD  VSI SSL111
$! 18-SEP-2018  MGD  detect OpenSSL v1.1 in WASD package
$! 03-AUG-2017  MGD  bugfix; BUILD_HTTPD_SSL
$! 13-AUG-2016  MGD  OpenSSL 1.1.0 (new VMS build environment)
$!                   HP SSL (OpenSSL v0.9.8n based) no longer supported
$!                   remove (specific) support for Polarhome OpenSSL kit
$! 24-APR-2016  MGD  HPE SSL1
$! 06-DEC-2014  MGD  remove support for JFP's OpenSSL package
$! 28-APR-2012  MGD  Polarhome OpenSSL (http://www.polarhome.com/openssl/)
$! 07-NOV-2009  MGD  WASD v10 logical naming schema
$! 22-SEP-2006  MGD  upper-case result from f$search() for SSL directory
$! 19-JUN-2005  MGD  Jean-Franois Pironne's OpenSSL package
$! 07-DEC-2002  MGD  initial (completely reworked for v8.1)
$!-----------------------------------------------------------------------------
$!
$ if f$trnlnm("INSTALL$DBUG") .nes. "" then set verify
$!
$ ss$_abort = 44
$ ss$_bugcheck = 676
$ p1 = f$edit(p1,"upcase")
$ say = "write sys$command"
$ on controly then exit ss$_abort
$ if f$environment("depth") .le. 1 then say ""
$!
$ if f$type(WASD_ARCH_NAME) .eqs. "" then @WASD_ROOT:[SRC]ARCHER.COM
$!
$ @[]SSL_DETECT_CANCEL.COM
$!
$ type sys$input
                            **********************
                            *  VSI OpenSSL Kits  *
                            **********************

As of late 2022 VSI OpenSSL kits should be fine for pre- VMS V8.4 systems.
Just ignore and continue after any warning regarding minimum VMS version.
As a consequence WASD OpenSSL kits will no longer be shipped.

$ vmsSSL31dir = ""
$ if p1 .eqs. "" .or. f$locate("+SSL31+",p1) .lt. f$length(p1)
$ then
$!   (SSL31 toolkit for OpenVMS - from the logical or look for it's directory)
$    vmsSSL31root = f$trnlnm("SSL31$ROOT")
$    if vmsSSL31root
$       then vmsSSL31dir = f$search("SSL31$ROOT:[000000]*.DIR")
$       else vmsSSL31dir = f$search("SYS$COMMON:[000000]SSL31.DIR")
$    endif
$    if vmsSSL31dir .nes. "" then WASD_SSLROOT = vmsSSL31dir
$ endif
$!
$ vmsSSL3dir = ""
$ if p1 .eqs. "" .or. f$locate("+SSL3+",p1) .lt. f$length(p1)
$ then
$!   (SSL3 toolkit for OpenVMS - from the logical or look for it's directory)
$    vmsSSL3root = f$trnlnm("SSL3$ROOT")
$    if vmsSSL3root
$       then vmsSSL3dir = f$search("SSL3$ROOT:[000000]*.DIR")
$       else vmsSSL3dir = f$search("SYS$COMMON:[000000]SSL3.DIR")
$    endif
$    if vmsSSL3dir .nes. "" then WASD_SSLROOT = vmsSSL3dir
$ endif
$!
$ vmsSSL111dir = ""
$ if p1 .eqs. "" .or. f$locate("+SSL111+",p1) .lt. f$length(p1)
$ then
$!   (SSL111 toolkit for OpenVMS - from the logical or look for it's directory)
$    vmsSSL111root = f$trnlnm("SSL111$ROOT")
$    if vmsSSL111root
$       then vmsSSL111dir = f$search("SSL111$ROOT:[000000]*.DIR")
$       else vmsSSL111dir = f$search("SYS$COMMON:[000000]SSL111.DIR")
$    endif
$ endif
$!
$ if vmsSSL111dir .eqs. "" .and. vmsSSL3dir .eqs. ""
$ then
$    type sys$input
                   **************************************
                   *  NO SSL TOOLKIT COULD BE LOCATED!  *
                   **************************************

None of the following SSL toolkits could be located.

  o  VMS SSL3 product (VSI)
  o  VMS SSL111 product (VSI)

$    if p1 .eqs. "SSL"
$    then
$       type sys$input
As an "SSL" build was specifically requested this cannot continue.

$       exit ss$_abort
$    else
$       type sys$input
A non-SSL version of the server will be built.

$       read sys$command response /prompt="Press RETURN to continue: "
$       say ""
$       exit
$    endif
$ endif
$!
$ if p1 .eqs. "SSL"
$ then
$!   (an SSL build as specifically requested, if there's only one toolkit)
$!
$    if vmsSSL111dir .nes. "" .and. vmsSSL3dir .eqs. ""
$    then
$!      (only the VMS SSL111 product was found)
$       say "The VMS SSL111 product will be used."
$       say ""
$       exit
$    endif
$!
$    if vmsSSL111dir .eqs. "" .and. vmsSSL3dir .nes. ""
$    then
$!      (only the VMS SSL3 product was found)
$       say "The VMS SSL3 product will be used."
$       say ""
$       exit
$    endif
$!
$    type sys$input
                    ************************************
                    *  MULTIPLE SSL TOOLKITS DETECTED  *
                    ************************************

Multiple supported Secure Sockets Layer (SSL) toolkits have been detected.
$!
$ else
$!
$    type sys$input
                         **************************
                         *  SSL TOOLKIT DETECTED  *
                         **************************

A supported Secure Sockets Layer (SSL) toolkit has been detected.
$!
$ endif
$!
$ option0 = 0
$ if p1 .eqs. "" .or. f$locate("+ZERO+",p1) .lt. f$length(p1) -
     then option0 = 1
$!
$ type sys$input
Those with item numbers are available for building, 'x's are not available.

$ if option0
$    then say "  0. do not build an SSL version"
$    else say "  x. do not build an SSL version"
$ endif
$ count = 0
$!
$ if vmsSSL31dir .nes. ""
$ then
$    count = count + 1
$    toolkit'count' = vmsSSL31dir
$    say "  ''count'. OpenVMS SSL31 product (VSI)"
$    count = count + 1
$    toolkit'count' = vmsSSL31dir + "SHR"
$    say "  ''count'. OpenVMS SSL31 product (VSI) SHAREABLE IMAGE link"
$ else
$    say "  x. OpenVMS SSL31 product (VSI)"
$ endif
$!
$ if vmsSSL3dir .nes. ""
$ then
$    count = count + 1
$    toolkit'count' = vmsSSL3dir
$    say "  ''count'. OpenVMS SSL3 product (VSI)"
$    count = count + 1
$    toolkit'count' = vmsSSL3dir + "SHR"
$    say "  ''count'. OpenVMS SSL3 product (VSI) SHAREABLE IMAGE link"
$ else
$    say "  x. OpenVMS SSL3 product (VSI)"
$ endif
$!
$ if vmsSSL111dir .nes. ""
$ then
$    count = count + 1
$    toolkit'count' = vmsSSL111dir
$    say "  ''count'. OpenVMS SSL111 product (VSI) [obsolescent]"
$    count = count + 1
$    toolkit'count' = vmsSSL111dir + "SHR"
$    say "  ''count'. OpenVMS SSL111 product (VSI) [obsolescent] SHAREABLE IMAGE link"
$ else
$    say "  x. OpenVMS SSL111 product (VSI)"
$ endif
$!
$! SELECT TOOLKIT
$!
$ toolkitLoop:
$    response = ""
$    say ""
$    read sys$command response /prompt="Select item number [0]: "
$    say ""
$    if response .eqs. "" then response = "0"
$    number = f$integer(response)
$    if number .lt. 0 .or. number .gt. count
$    then
$       say "RESPONSE ERROR! (enter a single digit 0 to ''count')"
$       goto toolkitLoop
$    endif
$ toolkitLoopEnd:
$!
$! SELECTION MADE
$!
$ if number .eq. 0
$ then
$   say "A non-SSL version of the application will be built."
$   say ""
$   define /process /nolog WASD_SSLROOT "!"
$   exit
$ endif
$!
$ if toolkit'number' .eqs. vmsSSL31dir
$ then
$    type sys$input
The VMS SSL31 (VSI) product has been selected.
$    product show product ssl31
$    read sys$command response /prompt="Press RETURN to continue: "
$    say ""
$    define /process /nolog WASD_SSLROOT "''f$trnlnm("SSL31$ROOT")'"
$    define /process /nolog WASD_OPENSSL "SSL31$ROOT:[INCLUDE]"
$    define /process /nolog WASD_LIBSSL "SSL31$ROOT:[LIB]SSL31$LIBSSL32.OLB/LIBRARY","21"
$    define /process /nolog WASD_LIBCRYPTO "SSL31$ROOT:[LIB]SSL31$LIBCRYPTO32.OLB/LIBRARY"
$    define /process /nolog WASD_SSL_DEMO "1"
$    exit
$ endif
$!
$ if toolkit'number' .eqs. (vmsSSL31dir + "SHR")
$ then
$    type sys$input
The VMS SSL31 product (VSI) SHAREABLE IMAGE has been selected.
$    product show product ssl31
$    read sys$command response /prompt="Press RETURN to continue: "
$    say ""
$    define /process /nolog WASD_SSLROOT "''f$trnlnm("SSL31$ROOT")'"
$    define /process /nolog WASD_OPENSSL "SSL31$ROOT:[INCLUDE]"
$    define /process /nolog WASD_LIBSSL "SYS$LIBRARY:SSL31$LIBSSL_SHR32.EXE/SHARE","22"
$    define /process /nolog WASD_LIBCRYPTO "SYS$LIBRARY:SSL31$LIBCRYPTO_SHR32.EXE/SHARE"
$    define /process /nolog WASD_SSL_DEMO "1"
$    exit
$ endif
$!
$ if toolkit'number' .eqs. vmsSSL3dir
$ then
$    type sys$input
The VMS SSL3 (VSI) product has been selected.
$    product show product ssl3
$    read sys$command response /prompt="Press RETURN to continue: "
$    say ""
$    define /process /nolog WASD_SSLROOT "''f$trnlnm("SSL3$ROOT")'"
$    define /process /nolog WASD_OPENSSL "SSL3$ROOT:[INCLUDE]"
$    define /process /nolog WASD_LIBSSL "SSL3$ROOT:[LIB]SSL3$LIBSSL32.OLB/LIBRARY","21"
$    define /process /nolog WASD_LIBCRYPTO "SSL3$ROOT:[LIB]SSL3$LIBCRYPTO32.OLB/LIBRARY"
$    define /process /nolog WASD_SSL_DEMO "1"
$    exit
$ endif
$!
$ if toolkit'number' .eqs. (vmsSSL3dir + "SHR")
$ then
$    type sys$input
The VMS SSL3 product (VSI) SHAREABLE IMAGE has been selected.
$    product show product ssl3
$    read sys$command response /prompt="Press RETURN to continue: "
$    say ""
$    define /process /nolog WASD_SSLROOT "''f$trnlnm("SSL3$ROOT")'"
$    define /process /nolog WASD_OPENSSL "SSL3$ROOT:[INCLUDE]"
$    define /process /nolog WASD_LIBSSL "SYS$LIBRARY:SSL3$LIBSSL_SHR32.EXE/SHARE","22"
$    define /process /nolog WASD_LIBCRYPTO "SYS$LIBRARY:SSL3$LIBCRYPTO_SHR32.EXE/SHARE"
$    define /process /nolog WASD_SSL_DEMO "1"
$    exit
$ endif
$!
$ if toolkit'number' .eqs. vmsSSL111dir
$ then
$    type sys$input
The VMS SSL111 (VSI) product has been selected.
$    product show product ssl111
$    read sys$command response /prompt="Press RETURN to continue: "
$    say ""
$    define /process /nolog WASD_SSLROOT "''f$trnlnm("SSL111$ROOT")'"
$    define /process /nolog WASD_OPENSSL "SSL111$ROOT:[INCLUDE]"
$    define /process /nolog WASD_LIBSSL "SSL111$ROOT:[LIB]SSL111$LIBSSL32.OLB/LIBRARY","11"
$    define /process /nolog WASD_LIBCRYPTO "SSL111$ROOT:[LIB]SSL111$LIBCRYPTO32.OLB/LIBRARY"
$    define /process /nolog WASD_SSL_DEMO "1"
$    exit
$ endif
$!
$ if toolkit'number' .eqs. (vmsSSL111dir + "SHR")
$ then
$    type sys$input
The VMS SSL111 product (VSI) SHAREABLE IMAGE has been selected.
$    product show product ssl111
$    read sys$command response /prompt="Press RETURN to continue: "
$    say ""
$    define /process /nolog WASD_SSLROOT "''f$trnlnm("SSL111$ROOT")'"
$    define /process /nolog WASD_OPENSSL "SSL111$ROOT:[INCLUDE]"
$    define /process /nolog WASD_LIBSSL "SYS$LIBRARY:SSL111$LIBSSL_SHR32.EXE/SHARE","12"
$    define /process /nolog WASD_LIBCRYPTO "SYS$LIBRARY:SSL111$LIBCRYPTO_SHR32.EXE/SHARE"
$    define /process /nolog WASD_SSL_DEMO "1"
$    exit
$ endif
$!
$ exit ss$_bugcheck
$!-----------------------------------------------------------------------------
