T /*        $OpenBSD: getopt_long.c,v 1.26 2013/06/08 22:47:56 millert Exp $        */N /*        $NetBSD: getopt_long.c,v 1.15 2002/01/31 22:43:40 tv Exp $        */   /*@  * Copyright (c) 2002 Todd C. Miller <Todd.Miller@courtesan.com>  *H  * Permission to use, copy, modify, and distribute this software for anyI  * purpose with or without fee is hereby granted, provided that the above D  * copyright notice and this permission notice appear in all copies.  *K  * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES C  * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF J  * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FORI  * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES H  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN ANJ  * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OFA  * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *>  * Sponsored in part by the Defense Advanced Research Projects>  * Agency (DARPA) and Air Force Research Laboratory, Air ForceC  * Materiel Command, USAF, under agreement number F39502-99-1-0512.   */  /*- 1  * Copyright (c) 2000 The NetBSD Foundation, Inc.   * All rights reserved.   *J  * This code is derived from software contributed to The NetBSD Foundation'  * by Dieter Baron and Thomas Klausner.   *E  * Redistribution and use in source and binary forms, with or without E  * modification, are permitted provided that the following conditions   * are met: D  * 1. Redistributions of source code must retain the above copyrightC  *    notice, this list of conditions and the following disclaimer. G  * 2. Redistributions in binary form must reproduce the above copyright I  *    notice, this list of conditions and the following disclaimer in the J  *    documentation and/or other materials provided with the distribution.  *L  * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORSN  * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITEDM  * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR L  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORSI  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR G  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF K  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS J  * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER INJ  * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)M  * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE   * POSSIBILITY OF SUCH DAMAGE.  */   
 #ifndef __VMS    #if 0 ( #if defined(LIBC_SCCS) && !defined(lint)X static char *rcsid = "$OpenBSD: getopt_long.c,v 1.16 2004/02/04 18:17:25 millert Exp $";# #endif /* LIBC_SCCS and not lint */  #endif #include <sys/cdefs.h> __FBSDID("$FreeBSD$");   #include <err.h> #include <errno.h> #include <getopt.h>  #include <stdlib.h>  #include <string.h>   S #define GNU_COMPATIBLE                /* Be more compatible, configure's use us! */   J #if 0                                /* we prefer to keep our getopt(3) */Z #define        REPLACE_GETOPT                /* use this getopt as the system getopt(3) */ #endif   #else /* __VMS */    #include <errno.h> #include "getopt.h"  #include <stdlib.h>  #include <string.h>   6 int        optreset;                /* reset getopt */   #endif /* __VMS */   #ifdef REPLACE_GETOPT N int        opterr = 1;                /* if error message should be printed */I int        optind = 1;                /* index into parent argv vector */ L int        optopt = '?';                /* character checked for validity */6 int        optreset;                /* reset getopt */E char    *optarg;                /* argument associated with option */  #endif  : #define PRINT_ERROR        ((opterr) && (*options != ':'))  T #define FLAG_PERMUTE        0x01        /* permute non-options to the end of argv */V #define FLAG_ALLARGS        0x02        /* treat non-options as args to option "-1" */J #define FLAG_LONGONLY        0x04        /* operate as getopt_long_only */   /* return values */ , #define        BADCH                (int)'?'N #define        BADARG                ((*options == ':') ? (int)':' : (int)'?')% #define        INORDER         (int)1   % #define        EMSG                ""    #ifdef GNU_COMPATIBLE  #define NO_PREFIX        (-1)  #define D_PREFIX        0  #define DD_PREFIX        1 #define W_PREFIX        2  #endif  = static int getopt_internal(int, char * const *, const char *, >                            const struct option *, int *, int);; static int parse_long_options(char * const *, const char *, F                               const struct option *, int *, int, int); static int gcd(int, int); 8 static void permute_args(int, int, int, char * const *);  9 static char *place = EMSG; /* option letter processing */   2 /* XXX: set optreset to 1 rather than these two */K static int nonopt_start = -1; /* first non option argument (for permute) */ P static int nonopt_end = -1;   /* first option after non options (for permute) */   /* Error messages */E static const char recargchar[] = "option requires an argument -- %c"; K static const char illoptchar[] = "illegal option -- %c"; /* From P1003.2 */  #ifdef GNU_COMPATIBLE # static int dash_prefix = NO_PREFIX; 8 static const char gnuoptchar[] = "invalid option -- %c";  H static const char recargstring[] = "option `%s%s' requires an argument";; static const char ambig[] = "option `%s%.*s' is ambiguous"; H static const char noarg[] = "option `%s%.*s' doesn't allow an argument";@ static const char illoptstring[] = "unrecognized option `%s%s'"; #else G static const char recargstring[] = "option requires an argument -- %s"; 7 static const char ambig[] = "ambiguous option -- %.*s"; F static const char noarg[] = "option doesn't take an argument -- %.*s";: static const char illoptstring[] = "unknown option -- %s"; #endif   /*2  * Compute the greatest common divisor of a and b.  */ 
 static int gcd(int a, int b)  {          int c;           c = a % b;         while (c != 0) {                 a = b;                 b = c;                 c = a % b;	         }            return (b);  }    /*D  * Exchange the block from nonopt_start to nonopt_end with the blockB  * from nonopt_end to opt_end (keeping the same order of arguments  * in each block).  */  static void ? permute_args(int panonopt_start, int panonopt_end, int opt_end,          char * const *nargv) { A         int cstart, cyclelen, i, j, ncycle, nnonopts, nopts, pos;          char *swap;   
         /*B          * compute lengths of blocks and number and size of cycles          */ 1         nnonopts = panonopt_end - panonopt_start; '         nopts = opt_end - panonopt_end; &         ncycle = gcd(nnonopts, nopts);7         cyclelen = (opt_end - panonopt_start) / ncycle;   &         for (i = 0; i < ncycle; i++) {(                 cstart = panonopt_end+i;                 pos = cstart; 0                 for (j = 0; j < cyclelen; j++) {0                         if (pos >= panonopt_end)0                                 pos -= nnonopts;                         else-                                 pos += nopts; *                         swap = nargv[pos];/                         /* LINTED const cast */ ?                         ((char **) nargv)[pos] = nargv[cstart]; /                         /* LINTED const cast */ 8                         ((char **)nargv)[cstart] = swap;                 } 	         }  }    /*  * parse_long_options --:  *        Parse long options in argc/argv argument vector.M  * Returns -1 if short_too is set and the option does not match long_options.   */ 
 static int< parse_long_options(char * const *nargv, const char *options,N         const struct option *long_options, int *idx, int short_too, int flags) { '         char *current_argv, *has_equal;  #ifdef GNU_COMPATIBLE          char *current_dash;  #endif          size_t current_argv_len;8         int i, match, exact_match, second_partial_match;           current_argv = place;  #ifdef GNU_COMPATIBLE          switch (dash_prefix) {                 case D_PREFIX:+                         current_dash = "-";                          break;                 case DD_PREFIX: ,                         current_dash = "--";                         break;                 case W_PREFIX:-                         current_dash = "-W ";                          break;                 default:*                         current_dash = "";                         break;	         }  #endif         match = -1;          exact_match = 0;!         second_partial_match = 0;            optind++;   >         if ((has_equal = strchr(current_argv, '=')) != NULL) {3                 /* argument found (--option=arg) */ <                 current_argv_len = has_equal - current_argv;                 has_equal++;         } else8                 current_argv_len = strlen(current_argv);  0         for (i = 0; long_options[i].name; i++) {/                 /* find matching long option */ ?                 if (strncmp(current_argv, long_options[i].name, &                     current_argv_len))!                         continue;   G                 if (strlen(long_options[i].name) == current_argv_len) { )                         /* exact match */ "                         match = i;(                         exact_match = 1;                         break;                 }                  /*?                  * If this is a known short option, don't allow 9                  * a partial match of a single character.                   */ 7                 if (short_too && current_argv_len == 1) !                         continue;   A                 if (match == -1)        /* first partial match */ "                         match = i;3                 else if ((flags & FLAG_LONGONLY) || 3                          long_options[i].has_arg != ;                              long_options[match].has_arg || L                          long_options[i].flag != long_options[match].flag ||H                          long_options[i].val != long_options[match].val)1                         second_partial_match = 1; 	         } 3         if (!exact_match && second_partial_match) { ,                 /* ambiguous abbreviation */                  if (PRINT_ERROR)$                         warnx(ambig, #ifdef GNU_COMPATIBLE *                              current_dash, #endif3                              (int)current_argv_len, +                              current_argv);                  optopt = 0;                  return (BADCH); 	         } <         if (match != -1) {                /* option found */>                 if (long_options[match].has_arg == no_argument#                     && has_equal) { (                         if (PRINT_ERROR),                                 warnx(noarg, #ifdef GNU_COMPATIBLE 2                                      current_dash, #endif;                                      (int)current_argv_len, 3                                      current_argv);                          /*I                          * XXX: GNU sets optopt to val regardless of flag                           */ =                         if (long_options[match].flag == NULL) A                                 optopt = long_options[match].val;                          else+                                 optopt = 0;  #ifdef GNU_COMPATIBLE '                         return (BADCH);  #else (                         return (BADARG); #endif                 } G                 if (long_options[match].has_arg == required_argument || G                     long_options[match].has_arg == optional_argument) { &                         if (has_equal)3                                 optarg = has_equal; ?                         else if (long_options[match].has_arg == 0                             required_argument) {"                                 /*K                                  * optional argument doesn't use next nargv #                                  */ 9                                 optarg = nargv[optind++];                          }                  } F                 if ((long_options[match].has_arg == required_argument)*                     && (optarg == NULL)) {                         /*K                          * Missing argument; leading ':' indicates no error /                          * should be generated.                           */ (                         if (PRINT_ERROR)3                                 warnx(recargstring,  #ifdef GNU_COMPATIBLE 1                                     current_dash,  #endif2                                     current_argv);                         /*I                          * XXX: GNU sets optopt to val regardless of flag                           */ =                         if (long_options[match].flag == NULL) A                                 optopt = long_options[match].val;                          else+                                 optopt = 0; !                         --optind; (                         return (BADARG);                 } <         } else {                        /* unknown option */                  if (short_too) {!                         --optind; $                         return (-1);                 }                   if (PRINT_ERROR)+                         warnx(illoptstring,  #ifdef GNU_COMPATIBLE +                               current_dash,  #endif,                               current_argv);                 optopt = 0;                  return (BADCH); 	         }          if (idx)                 *idx = match; '         if (long_options[match].flag) { D                 *long_options[match].flag = long_options[match].val;                 return (0);          } else1                 return (long_options[match].val);  }    /*  * getopt_internal -- J  *        Parse argc/argv argument vector.  Called by user level routines.  */ 
 static intD getopt_internal(int nargc, char * const *nargv, const char *options,?         const struct option *long_options, int *idx, int flags)  { P         char *oli;                                /* option letter list index */         int optchar, short_too; (         static int posixly_correct = -1;           if (options == NULL)                 return (-1);  
         /*F          * XXX Some GNU programs (like cvs) set optind to 0 instead of=          * XXX using optreset.  Work around this braindamage.           */          if (optind == 0)&                 optind = optreset = 1;  
         /*F          * Disable GNU extensions if POSIXLY_CORRECT is set or options$          * string begins with a '+'.          */ .         if (posixly_correct == -1 || optreset)F                 posixly_correct = (getenv("POSIXLY_CORRECT") != NULL);         if (*options == '-')&                 flags |= FLAG_ALLARGS;4         else if (posixly_correct || *options == '+')'                 flags &= ~FLAG_PERMUTE; /         if (*options == '+' || *options == '-')                  options++;           optarg = NULL;         if (optreset) /                 nonopt_start = nonopt_end = -1;  start:O         if (optreset || !*place) {                /* update scanning pointer */                  optreset = 0; L                 if (optind >= nargc) {          /* end of argument vector */%                         place = EMSG; /                         if (nonopt_end != -1) { C                                 /* do permutation, if we have to */ F                                 permute_args(nonopt_start, nonopt_end,3                                     optind, nargv); D                                 optind -= nonopt_end - nonopt_start;                         } 6                         else if (nonopt_start != -1) {"                                 /*H                                  * If we skipped non-options, set optind8                                  * to the first of them.#                                  */ 6                                 optind = nonopt_start;                         } 7                         nonopt_start = nonopt_end = -1; $                         return (-1);                 } 6                 if (*(place = nargv[optind]) != '-' || #ifdef GNU_COMPATIBLE '                     place[1] == '\0') {  #else I                     (place[1] == '\0' && strchr(options, '-') == NULL)) {  #endifK                         place = EMSG;                /* found non-option */ 3                         if (flags & FLAG_ALLARGS) { "                                 /*1                                  * GNU extension: L                                  * return non-option as argument to option 1#                                  */ 9                                 optarg = nargv[optind++]; 1                                 return (INORDER);                          } 6                         if (!(flags & FLAG_PERMUTE)) {"                                 /*I                                  * If no permutation wanted, stop parsing 7                                  * at first non-option. #                                  */ ,                                 return (-1);                         } ,                         /* do permutation *//                         if (nonopt_start == -1) 6                                 nonopt_start = optind;4                         else if (nonopt_end != -1) {F                                 permute_args(nonopt_start, nonopt_end,3                                     optind, nargv); 7                                 nonopt_start = optind - @                                     (nonopt_end - nonopt_start);0                                 nonopt_end = -1;                         } !                         optind++; 3                         /* process next argument */ #                         goto start;                  } ;                 if (nonopt_start != -1 && nonopt_end == -1) ,                         nonopt_end = optind;                   /*B                  * If we have "-" do nothing, if "--" we are done.                  */ N                 if (place[1] != '\0' && *++place == '-' && place[1] == '\0') {!                         optind++; %                         place = EMSG;                          /*D                          * We found an option (--), so if we skipped;                          * non-options, we have to permute.                           */ /                         if (nonopt_end != -1) { F                                 permute_args(nonopt_start, nonopt_end,3                                     optind, nargv); D                                 optind -= nonopt_end - nonopt_start;                         } 7                         nonopt_start = nonopt_end = -1; $                         return (-1);                 } 	         }   
         /*!          * Check long options if: "          *  1) we were passed some&          *  2) the arg is not just "-"F          *  3) either the arg starts with -- we are getopt_long_only()          */ =         if (long_options != NULL && place != nargv[optind] && 9             (*place == '-' || (flags & FLAG_LONGONLY))) {                  short_too = 0; #ifdef GNU_COMPATIBLE '                 dash_prefix = D_PREFIX;  #endif$                 if (*place == '-') {G                         place++;                /* --foo long option */ +                         if (*place == '\0') N                                 return (BADARG);        /* malformed option */ #ifdef GNU_COMPATIBLE 0                         dash_prefix = DD_PREFIX; #endifL                 } else if (*place != ':' && strchr(options, *place) != NULL)U                         short_too = 1;                /* could be short option too */   J                 optchar = parse_long_options(nargv, options, long_options,+                     idx, short_too, flags); $                 if (optchar != -1) {%                         place = EMSG; )                         return (optchar);                  } 	         }   4         if ((optchar = (int)*place++) == (int)':' ||6             (optchar == (int)'-' && *place != '\0') ||7             (oli = strchr(options, optchar)) == NULL) {                  /*E                  * If the user specified "-" and  '-' isn't listed in @                  * options, return -1 (non-option) as per POSIX.I                  * Otherwise, it is an unknown option character (or ':').                   */ :                 if (optchar == (int)'-' && *place == '\0')$                         return (-1);                 if (!*place)!                         ++optind;  #ifdef GNU_COMPATIBLE                   if (PRINT_ERROR)H                         warnx(posixly_correct ? illoptchar : gnuoptchar,'                               optchar);  #else                   if (PRINT_ERROR)3                         warnx(illoptchar, optchar);  #endif!                 optopt = optchar;                  return (BADCH); 	         } F         if (long_options != NULL && optchar == 'W' && oli[1] == ';') {$                 /* -W long-option */A                 if (*place)                        /* no space */ &                         /* NOTHING */;A                 else if (++optind >= nargc) {        /* no arg */ %                         place = EMSG; (                         if (PRINT_ERROR);                                 warnx(recargchar, optchar); )                         optopt = optchar; (                         return (BADARG);G                 } else                                /* white space */ .                         place = nargv[optind]; #ifdef GNU_COMPATIBLE '                 dash_prefix = W_PREFIX;  #endifJ                 optchar = parse_long_options(nargv, options, long_options,#                     idx, 0, flags);                  place = EMSG; !                 return (optchar); 	         } O         if (*++oli != ':') {                        /* doesn't take argument */                  if (!*place)!                         ++optind; O         } else {                                /* takes (optional) argument */                  optarg = NULL;G                 if (*place)                        /* no white space */ '                         optarg = place; G                 else if (oli[1] != ':') {        /* arg not optional */ D                         if (++optind >= nargc) {        /* no arg */-                                 place = EMSG; 0                                 if (PRINT_ERROR)C                                         warnx(recargchar, optchar); 1                                 optopt = optchar; 0                                 return (BADARG);                         } else7                                 optarg = nargv[optind];                  }                  place = EMSG;                  ++optind; 	         } %         /* dump back option letter */          return (optchar);  }    #ifdef REPLACE_GETOPT  /*  * getopt --*  *        Parse argc/argv argument vector.  *0  * [eventually this will replace the BSD getopt]  */  int ; getopt(int nargc, char * const *nargv, const char *options)  {   
         /*@          * We don't pass FLAG_PERMUTE to getopt_internal() since>          * the BSD getopt(3) (unlike GNU) has never done this.
          *D          * Furthermore, since many privileged programs call getopt()C          * before dropping privileges it makes sense to keep things 0          * as simple (and bug-free) as possible.          */ G         return (getopt_internal(nargc, nargv, options, NULL, NULL, 0));  }  #endif /* REPLACE_GETOPT */    /*  * getopt_long -- *  *        Parse argc/argv argument vector.  */  int @ getopt_long(int nargc, char * const *nargv, const char *options,4         const struct option *long_options, int *idx) {   I         return (getopt_internal(nargc, nargv, options, long_options, idx,              FLAG_PERMUTE));  }    /*  * getopt_long_only --*  *        Parse argc/argv argument vector.  */  int E getopt_long_only(int nargc, char * const *nargv, const char *options, 4         const struct option *long_options, int *idx) {   I         return (getopt_internal(nargc, nargv, options, long_options, idx, )             FLAG_PERMUTE|FLAG_LONGONLY));  } 