$!-----------------------------------------------------------------------------
$! BUILD_WUCME.COM
$!
$! P1 == COMPILE, LINK or BUILD (empty cannot be used)
$!
$! 14-DEC-2024  MGD  use [INSTALL]SSL_DETECT.COM
$! 15-JAN-2023  MGD  build under VSI SSL 3.0
$! 08-AUG-2019  MGD  initial
$!-----------------------------------------------------------------------------
$!
$ on controly then exit 44
$ say = "write sys$output"
$!
$ @[]archer.com "WUCME"
$!
$ p1 = f$edit(p1,"upcase")
$!
$! *******************
$! *  P1 build type  *
$! *******************
$!
$ if p1 .eqs. "" then p1 = "BUILD"
$ if p1 .nes. "COMPILE" .and. p1 .nes. "LINK" .and. p1 .nes. "BUILD"
$ then
$    say "P1 must be one of ""COMPILE"", ""BUILD"" or ""LINK""!"
$    exit 44
$ endif
$!
$ say ""
$ @[]ssl_detect "+SSL3+SSL31+"
$!
$ if f$trnlnm("WASD_SSLROOT") .eqs. "!"
$ then
$    say "Error!  Requires SSL."
$    exit 44
$ endif
$!
$ define /process /nolog openssl 'f$trnlnm("WASD_OPENSSL")'
$!
$ if f$search("openssl:ssl.h") .eqs. ""
$ then
$    say "Error in SSL package root directory specification?"
$    exit 44
$ endif
$!
$! *************
$! *  compile  *
$! *************
$!
$ defines = "/define=(__VMS_VER=70000000,__CRTL_VER=70000000)"
$ warnings=  " /warning=(disable=(PREOPTW))"
$ includes = ""
$!
$ cc_options = "/decc /optimize /float=ieee /ieee=denorm " +-
               "/stand=relaxed_ansi /prefix=all /names=as_is " +-
               includes + defines + warnings
$!
$ if p1 .eqs. "" .or. p1 .eqs. "BUILD" .or. p1 .eqs. "COMPILE"
$ then
$    set noon
$    set verify
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' acme_tls_1
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' base64
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' crypto
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' curlwrap
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' json
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' msg
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' read-file
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' uacme
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' wucme
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' wucertman
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' wuhttp01
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' wuhttps
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' wureport
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' wuscript
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' wutil
$    cc 'cc_options' /nodebug /object='wasd_obj_dir' getopt_long
$!   'f$verify(0)
$    set on
$ endif
$!
$! **********
$! *  link  *
$! **********
$!
$ linkit:
$ if p1 .eqs. "" .or. p1 .eqs. "BUILD" .or. p1 .eqs. "LINK"
$ then
$    crypto = f$trnlnm("WASD_LIBCRYPTO")
$    if f$locate("/LIB",crypto) .lt. f$length(crypto)
$    then
$       options = "ssl_3_lib.opt"
$       if f$locate("SSL31",crypto) .lt. f$length(crypto) -
           then options = "ssl_31_lib.opt"
$    else
$       options = "ssl_3_shr.opt"
$       if f$locate("SSL31",crypto) .lt. f$length(crypto) -
           then options = "ssl_31_shr.opt"
$    endif
$    set noon
$    set verify
$    link /notrace/executable='wasd_obj_dir'wucme.exe -
     'wasd_obj_dir'acme_tls_1,-
     'wasd_obj_dir'base64,-
     'wasd_obj_dir'crypto,-
     'wasd_obj_dir'curlwrap,-
     'wasd_obj_dir'json,-
     'wasd_obj_dir'msg,-
     'wasd_obj_dir'read-file,-
     'wasd_obj_dir'uacme,-
     'wasd_obj_dir'wucme,-
     'wasd_obj_dir'wucertman,-
     'wasd_obj_dir'wuhttp01,-
     'wasd_obj_dir'wuhttps,-
     'wasd_obj_dir'wureport,-
     'wasd_obj_dir'wuscript,-
     'wasd_obj_dir'wutil,-
     'wasd_obj_dir'getopt_long,-
     []'options'/options
$!   'f$verify(0)
$    set on
$ endif
$ purge /nolog 'wasd_obj_dir'
$!
$ @[]ssl_detect_cancel
$!
$!-----------------------------------------------------------------------------
