$!-----------------------------------------------------------------'f$verify(0)
$! BUILD_HTTPD.COM
$!
$! P1..P8
$!
$! "BUILD"         compile/link
$! "BUILD:LOCAL"   compile/link using local VMS and C RTL versions
$! "BUILD:HOST"    compile/link as above plus using /ARCHITECTURE=HOST
$! "COMPILE"       compile only
$! "COMPILE:LIST"  compile only, producing machine code listing
$! "DEBUG"         compile /DEBUG/NOOPTIMIZE, link /DEBUG/TRACEBACK
$! "JUST:module"   to compile just that module
$! "JUST:SSL"      to compile all the SSL-related modules
$! "LINK"          link only
$! "LINK:MAP"      link only, producing linkage map
$!
$! "SSL111=1"      build with VSI OpenVMS (Open)SSL111 product
$! "SSL111_SHR=1"  build with sharable VSI OpenVMS (Open)SSL111 product
$! "SSL3=1"        build with VSI OpenVMS (Open)SSL3 product
$! "SSL3_SHR=1"    build with sharable VSI OpenVMS (Open)SSL3 product
$! "SSL31=1"       build with VSI OpenVMS (Open)SSL31 product
$! "SSL31_SHR=1"   build with sharable VSI OpenVMS (Open)SSL31 product
$! "SSL32=1"       build with VSI OpenVMS (Open)SSL32 product
$! "SSL32_SHR=1"   build with sharable VSI OpenVMS (Open)SSL32 product
$! "SSL0=1"        build using locally define OSSL* logiclals
$!
$! "TCPIP6_STUB"   force compilation of TCPIP6 "stub" on VMS pre-V7.0 
$! $ DEFINE/JOB WASD_TCPIP6_STUB [0|1] overrides during @INSTALL and @UPDATE
$!                 (some versions of TCP/IP services don't have get..info())
$! "ACME=0"        build without authorization ACME support (VAX or pre-V7.3)
$! "ACME=1"        build with authorization ACME support
$! "WATCH_CAT=0"   eliminates category WATCHing statements (admin)
$! "WATCH_MOD=1"   includes module WATCHing statements (debugging)
$! "FLOAT_IEEE=1"  use IEEE float
$!
$! By default the software is built with a base compliance to VMS V7.0.
$! This is done to make the object modules as broadly portable as possible.
$! Using BUILD:LOCAL will build against whatever version of VMS and C RTL is
$! available on the local system.  This may provide run-time efficiencies, etc.
$! It also MAY allow the server to be built on VMS V6.0 (but unsupported).
$! Note however that the package is only extensively tested using the
$! base-level build, so unexpected behaviours (i.e. bugs ;^) may be revealed
$! by the different build and run-time environment.
$! 
$! For a non-WASD-default location for the OpenSSL compile-time environment
$! use the VMS OpenSSL standard logical locations (i.e. SSLROOT).
$!
$! When building using VMS (VSI) OpenSSL v1.1.n or later, and OpenSSL 3.0.n, be
$! aware that it uses shareable libraries that must be INSTALLed before the
$! WASD server image can be activated (which is not a bad idea anyway).
$!
$!   $ INSTALL ADD /OPEN /HEADER /SHARE SYS$LIBRARY:SSL$LIBCRYPTO_SHR32.EXE
$!   $ INSTALL ADD /OPEN /HEADER /SHARE SYS$LIBRARY:SSL$LIBSSL_SHR32.EXE
$!
$!   $ INSTALL ADD /OPEN /HEADER /SHARE SYS$LIBRARY:SSL1$LIBCRYPTO_SHR32.EXE
$!   $ INSTALL ADD /OPEN /HEADER /SHARE SYS$LIBRARY:SSL1$LIBSSL_SHR32.EXE
$!
$! 01-DEC-2025  MGD  modify SSL0 to accomodate local OpenSSL object libraries
$!                     SSL$LIBSSL32.OLB and OSSL$LIBCRYPTO32.OLB
$! 25-MAY-2025  MGD  optional BUILD_BASE = "WASD_VMS_V7" so builds native
$!                   PROXYREWORK.C obsolete
$! 07-DEC-2024  MGD  @BUILD_CLEAN
$! 15-SEP-2024  MGD  SESOLACME.C build
$!                   PROXYFTP.C obsolete
$! 23-MAR-2023  MGD  SSL31 supported (plus SSL32 -- speculative inclusion)
$! 01-FEB-2023  MGD  DELETE PROXYCACHE.*;*
$! 19-MAY-2022  MGD  SESOLA123 and SESOLA321 to allow OpenSSL-3.0 and
$!                     OpenSSL-1.1.1 to be built using the same object code
$! 18-FEB-2022  MGD  refactor TLS/SSL builds
$!                   drop OSSL$ and all defunct, SSL111$, SSL3$ and WASD builds
$! 08-SEP-2021  MGD  WASD OpenSSL 3.0 (broken at this stage)
$! 14-MAR-2021  MGD  proxy caching obsolete
$! 12-NOV-2020  MGD  VAX no longer supported - it did have a 26 year run!
$! 18-JUL-2020  MGD  add SESOLAMKCERT.C
$! 30-JUN-2020  MGD  remove VAX SSL and pre-1.1.1 OpenSSL builds
$! 18-JAN-2020  MGD  VSI SSL111
$! 15-JUL-2019  MGD  add SYSPLUS.C
$! 15-SEP-2018  MGD  refactor SSL detection
$!                   use WASD OpenSSL v1.1.n in preference to system
$!                   obsolete PERSONA_STUB and PERSONA_MACRO
$! 08-OCT-2017  MGD  add DCLMEMBUF.C
$! 16-MAR-2017  MGD  SNAPSSL=1 to build with OpenSSL daily snapshot 
$! 25-AUG-2016  MGD  OpenSSL v1.1.0 or later (preliminary) build
$!                   VMS_SSL (HP SSL - OpenSSL v0.9.8n) no longer supported
$!                   remove JFP and Polarhome kit builds
$! 11-MAY-2016  MGD  DELETE ISMAP.*;*,FILEDOT.*;*,MENU.*;*,TRACK.*;*
$! 25-APR-2016  MGD  HPE SSL1
$! 28-DEC-2015  MGD  add REDIRECT.C
$! 11-OCT-2015  MGD  SESOLACERT.C
$! 03-AUG-2015  MGD  add HTTP2[..].C HPACK[..].C NETIO.C
$!                   add SESOLACERT.C SESOLANETIO.C
$!                   remove ISMAP.C FILEDOT.C MENU.C
$! 13-APR-2014  MGD  OpenSSL build and link data for SSL report
$! 09-SEP-2012  MGD  AUTHTOKEN.C
$! 28-APR-2012  MGD  Polarhome (http://www.polarhome.com/openssl/) OpenSSL
$! 20-SEP-2011  MGD  dragged kicking and screaming to VMS V7.0 base build
$! 18-SEP-2011  MGD  OpenSSL / WASD SSL now built with 32/64 bit pointers
$! 18-JAN-2011  MGD  BASE64.C SHA1.C
$! 30-AUG-2010  MGD  TCPIP6.C
$! 26-JUN-2010  MGD  WebSock.c
$! 03-APR-2010  MGD  OpenSSL v1.n.n on Alpha uses [.ALPHA] not [.AXP]
$! 14-SEP-2007  MGD  make IEEE the default on non-VAX architectures
$! 31-DEC-2006  MGD  WebDAV modules
$! 21-SEP-2006  MGD  upper-case OpenSSL directory search
$! 23-APR-2006  MGD  include SECOLACACHE.OBJ in non-SSL build
$! 27-JUN-2005  MGD  bugfix; CC_DEFINES in non-SSL build
$! 10-APR-2005  MGD  DIST build defer to VMS SSL (rather than WASD SSL)
$!                   build IA64 ACME/stub by differentiating against VAX
$! 26-MAR-2005  MGD  add /ARCH=HOST to local build compile
$! 22-FEB-2005  JFP  JFP_SSL and /FLOAT=IEEE optional build  
$! 17-OCT-2004  MGD  v9.0, GZIP.C, PROXYNET.C, PROXYTUNNEL.C
$! 17-OCT-2004  MGD  (woops) include ACME=0 in distribution build
$! 10-APR-2004  MGD  v8.5, AUTHACME.C, TCPIP.C
$! 20-DEC-2003  MGD  v8.4,
$!                   support building under IA64
$! 20-NOV-2003  MGD  PROXYVERIFY.C
$! 03-MAY-2003  MGD  REGEX.C
$! 15-APR-2003  MGD  bugfix; for OpenSSL installed away from original package
$! 08-MAR-2003  MGD  delete all existing object files before full build
$! 22-JAN-2003  MGD  add '.c' to compiles after report of failure (on CGI)
$!                   when a logical name is defined against the string
$! 10-AUG-2002  MGD  build against VMS (Open)SSL v1.0-A
$! 05-JUL-2002  MGD  V8.0,
$!                   rework procedure parameter processing,
$!                   removed requirement for OpenSSL SSL_LOCL.H
$! 28-JAN-2002  MGD  expand SESOLA modules, add FTP and BODY modules
$! 28-OCT-2001  MGD  PERSONA_MACRO/PERSONA.MAR
$! 04-AUG-2001  MGD  WATCH_MOD and WATCH_CAT
$! 01-JUL-2001  MGD  further refinement
$! 18-MAY-2001  MGD  THROTTLE.C, FAO.C modules
$! 07-APR-2001  MGD  explicitly build the link options file,
$!                   use OpenSSL directory logicals
$! 13-FEB-2001  MGD  AUTHIDENT.C module
$! 01-OCT-2000  MGD  PERSONA.C module
$! 12-SEP-2000  MGD  make OpenSSL directory determination more flexible
$! 09-AUG-2000  MGD  WASD_BUILD_DEFINES
$! 13-JUN-2000  MGD  v7.1,
$!                   SERVICE.C module
$! 05-MAR-2000  MGD  v7.0,
$!                   ODS (extended file specification) support,
$!                   OpenSSL v0.9.5 support
$! 23-DEC-1999  MGD  v6.1.2,
$!                   RELAXED_ANSI standard (DECC v6.2)
$! 28-AUG-1999  MGD  v6.1,
$!                   remove support for NETLIB,
$!                   support for OpenSSL v0.9.4,
$!                   remove support for SSLeay
$! 02-APR-1999  MGD  generalize for OpenSSL v0.9.3
$! 24-DEC-1998  MGD  HTTPd version 6,
$!                   add proxy modules,
$!                   suppress informational messages (DECC 5.7)
$! 03-JUL-1998  MGD  SSLeay v0.9.0b,
$!                   build for TCPware in UCX compatibility mode
$! 14-MAY-1998  MGD  add defines for __VMS_VER, __CRTL_VER, __VMS_V6_SOURCE
$!                   (ensure v7.1 compilations can be executed on v6.n),
$!                   distributing as .OBJ ... need UCX and NETLIB object files
$! 07-JAN-1998  MGD  HTTPd version 5
$!                   added SSL (SSLeay) build support
$!                   removed optimization, seemed to be inducing problems
$! 07-SEP-1997  MGD  modified to support DBUG and to retain NETLIB objects
$! 23-JUL-1997  MGD  MultiNet dropped in favour of NETLIB 2.1
$! 01-FEB-1997  MGD  HTTPd version 4
$! 06-JAN-1996  MGD  build for either UCX or MultiNet
$! 01-DEC-1995  MGD  HTTPd version 3
$! 24-MAY-1995  MGD  build for AXP systems
$! 20-DEC-1994  MGD  multi-threaded server
$! 20-JUN-1994  MGD  single-threaded server
$!-----------------------------------------------------------------------------
$!
$ IF F$TRNLNM ("BUILD_HTTPD_VERIFY") .NES. "" THEN SET VERIFY
$ SET CONTROL=Y
$ ON CONTROLY THEN GOTO FINISHED
$!
$ STIME = F$TIME()
$!
$ IF F$GETSYI("ARCH_NAME") .EQS. "VAX"
$ THEN
$    WRITE SYS$OUTPUT "VAX no longer supported - it did have a 26 year run!"
$    EXIT 44
$ ENDIF
$!
$ @WASD_ROOT:[SRC]ARCHER.COM "HTTPD"
$!
$ CALL DEASSIGN_WORKING_LOGICAL_NAMES
$ VMS_VERSION = F$GETSYI("VERSION")
$ VMS_VERSION = F$INTEGER(F$EXTRACT(1,1,VMS_VERSION)) * 10 +-
                F$INTEGER(F$EXTRACT(3,1,VMS_VERSION))
$ PREVDEFAULT = F$ENVIRONMENT("DEFAULT")
$ PROCEDURE = F$ENVIRONMENT("PROCEDURE")
$ DEFAULT = F$PARSE(PROCEDURE,,,"DEVICE") + F$PARSE(PROCEDURE,,,"DIRECTORY")
$ SET DEFAULT 'DEFAULT'
$!
$ BUILDLOCAL = 0
$ BUILDHOST = 0
$ COMPILEONLY = 0
$ COMPILELIST = ""
$ DEBUGTRACE = 0
$ DBUG = ""
$ JUST = ""
$ LINKONLY = 0
$ LINKMAP = ""
$ WASD_SSL = 0
$ VMS_SSL = 0
$ ZLIB = 1
$ SESOLA = ""
$ SESOLA_EXE = ""
$ SESOLA_OBJ = ""
$ SESOLA_FROM = "Without SSL"
$ SSL_ROOT = ""
$ SSL_INCLUDE = ""
$ IF VMS_VERSION .LT. 70 THEN TCPIP6_STUB = 1
$ IF F$TRNLNM("WASD_TCPIP6_STUB") .NES. "" -
     THEN TCPIP6_STUB = F$TRNLNM("WASD_TCPIP6_STUB")
$ WASD_ACME = ""
$ WATCH_CAT = "WATCH_CAT=1"
$ WATCH_MOD = "WATCH_MOD=0"
$ WEBDAV_EXPAT = 1
$ WASD_GETSPI = ""
$ WASD_GETSPI = "WASD_GETSPI=1"
$!
$ WARN = " /WARNING=(NOINFORM,DISABLE=(PREOPTW))"
$ FLOAT_IEEE = 1
$!
$ COUNT = 0
$ PARAMETER_LOOP:
$!
$!   **************
$!   * PARAM LOOP *
$!   **************
$!
$    COUNT = COUNT + 1
$    IF COUNT .GT. 8 THEN GOTO END_PARAMETER_LOOP
$    P0 = P'COUNT'
$    IF P0 .EQS. "" THEN GOTO PARAMETER_LOOP
$    WRITE SYS$OUTPUT "P''COUNT'=" + P0
$!
$    IF P0 .EQS. "BUILD"
$    THEN
$       COMPILEONLY = 0
$       LINKONLY = 0
$    ENDIF
$    IF P0 .EQS. "BUILD:LOCAL" .OR. P0 .EQS. "BUILDLOCAL" THEN BUILDLOCAL = 1
$    IF P0 .EQS. "BUILD:HOST" .OR. P0 .EQS. "BUILDHOST" THEN BUILDHOST = 1
$!
$    IF P0 .EQS. "COMPILE" THEN COMPILEONLY = 1
$    IF P0 .EQS. "COMPILE:LIST" .OR. P0 .EQS. "COMPILE_LIST"
$    THEN
$       COMPILELIST = " /LIST /MACHINE"
$       COMPILEONLY = 1
$       LINKONLY = 0
$    ENDIF
$!
$    IF P0 .EQS. "DBUG"
$    THEN
$       DBUG = "DBUG"
$       WATCH_MOD = "WATCH_MOD=1"
$    ENDIF
$!
$    IF F$ELEMENT(0,":",P0) .EQS. "JUST"
$    THEN
$       JUST = F$ELEMENT(1,":",P0)
$       COMPILEONLY = 1
$       LINKONLY = 0
$    ENDIF
$!
$    IF P0 .EQS. "LINK" THEN LINKONLY = 1
$    IF P0 .EQS. "LINK:MAP" .OR. P0 .EQS. "LINK_MAP"
$    THEN
$       LINKMAP = " /MAP=HTTPD''SESOLA_EXE'.MAP/FULL"
$       LINKONLY = 1
$       COMPILEONLY = 0
$    ENDIF
$!
$    IF P0 .EQS. "TCPIP6_STUB" THEN TCPIP6_STUB = 1
$!
$    CALL CHECK_FOR_SSL "''P0'"
$    IF F$LENGTH(F$TRNLNM("WASD_SSLROOT","LNM$PROCESS")) .gt. 1
$    THEN
$       DEFINE SSLROOT /PROCESS /NOLOG /TRANSLATION=CONCEALED -
               'F$TRNLNM("WASD_SSLROOT","LNM$PROCESS")'
$       DEFINE OPENSSL /PROCESS /NOLOG -
               'F$TRNLNM("WASD_OPENSSL","LNM$PROCESS")'
$       SESOLA_FROM = "OpenSSL from " +-
                      F$TRNLNM("WASD_SSLROOT","LNM$PROCESS") - ".]"
$       SESOLA = "SESOLA"
$       WASD_SSLROOT = F$TRNLNM("WASD_SSLROOT","LNM$PROCESS")
$       IF F$EXTRACT(0,6,WASD_SSLROOT) .EQS. "SSL0$" THEN SESOLA = "SESOLA0"
$       IF F$EXTRACT(0,7,WASD_SSLROOT) .EQS. "SSL111$" THEN SESOLA = "SESOLA111"
$       IF F$EXTRACT(0,5,WASD_SSLROOT) .EQS. "SSL3$" THEN SESOLA = "SESOLA3"
$       IF F$EXTRACT(0,6,WASD_SSLROOT) .EQS. "SSL31$" THEN SESOLA = "SESOLA31"
$       IF F$EXTRACT(0,6,WASD_SSLROOT) .EQS. "SSL32$" THEN SESOLA = "SESOLA32"
$       WASD_LIBSSL = F$TRNLNM("WASD_LIBSSL","LNM$PROCESS")
$       IF F$LOCATE("/SHARE",WASD_LIBSSL) .LT. F$LENGTH(WASD_LIBSSL) -
           THEN SESOLA = SESOLA + "/SHARE"
$       SESOLA_EXE = "_SSL"
$       SESOLA_OBJ = "_SSL"
$    ENDIF
$!
$    IF P0 .EQS. "DEBUG" THEN DEBUGTRACE = 1
$    IF P0 .EQS. "WARN" THEN WARN = ""
$    IF P0 .EQS. "WATCH_CAT=0" THEN WATCH_CAT = "WATCH_CAT=0"
$    IF P0 .EQS. "WATCH_MOD=1" THEN WATCH_MOD = "WATCH_MOD=1"
$    IF P0 .EQS. "ACME=1" THEN WASD_ACME = "WASD_ACME=1"
$    IF P0 .EQS. "ACME=0" THEN WASD_ACME = "WASD_ACME=0"
$    IF P0 .EQS. "FLOAT_IEEE=0" THEN FLOAT_IEEE=0
$    IF P0 .EQS. "FLOAT_IEEE=1" THEN FLOAT_IEEE=1
$!
$    GOTO PARAMETER_LOOP
$!
$ END_PARAMETER_LOOP:
$!
$ IF DEBUGTRACE
$ THEN
$    DEBUGQUAL == "/DEBUG"
$    TRACEQUAL == "/TRACE"
$ ELSE
$    DEBUGQUAL == "/NODEBUG"
$    TRACEQUAL == "/NOTRACE"
$ ENDIF
$!
$ IF F$SEARCH("PROXYREWORK.C") .NES. "" THEN DELETE/NOCONFIRM/NOLOG PROXYREWORK.C;*
$!
$! (ACME is only with VMS 7.3 or later)
$ IF WASD_ACME .EQS. "" .AND. VMS_VERSION .GE. 73 -
     THEN WASD_ACME = "WASD_ACME=1"
$ IF WASD_ACME .EQS. "WASD_ACME=1" 
$ THEN
$    ACME_STUB = 0
$    ACME_OBJ = ""
$ ELSE
$    WASD_ACME = "WASD_ACME=0"
$    ACME_STUB = 1
$    ACME_OBJ = "_STUB"
$ ENDIF
$!
$ IF F$TYPE(TCPIP6_STUB) .EQS. "" THEN TCPIP6_STUB = 0
$!
$ IF WASD_ARCH_NAME .EQS. "X86_64"
$ THEN
$    BUILD_HTTPD_LOCAL = 1
$ ELSE
$    IF F$TYPE(BUILD_HTTPD_LOCAL) .EQS. "" THEN BUILD_HTTPD_LOCAL = 0
$ ENDIF
$ IF BUILD_HTTPD_LOCAL
$    THEN CC_DEFINES = "WASD_VMS_V0"
$    ELSE CC_DEFINES = "WASD_VMS_V7"
$ ENDIF
$ IF DEBUGTRACE
$ THEN
$    OPTIMIZE = "/NOOPTIMIZE"
$ ELSE
$    OPTIMIZE = "/OPTIMIZE"
$    !(BUILD_HTTPD_LOCAL is a symbol assigned by INSTALL.COM, etc.)
$    IF BUILDLOCAL .OR. BUILD_HTTPD_LOCAL
$    THEN
$       CC_DEFINES = ""
$       OPTIMIZE = "/OPTIMIZE=(INLINE=AUTO,LEVEL=4,UNROLL=0,TUNE=HOST)"
$    ENDIF
$    !(BUILD_HTTPD_HOST is a symbol assigned by INSTALL.COM, etc.)
$    IF BUILDHOST .OR. F$TYPE(BUILD_HTTPD_HOST) .NES. ""
$    THEN
$       CC_DEFINES = ""
$       OPTIMIZE = "/OPTIMIZE=(INLINE=AUTO,LEVEL=4,UNROLL=0,TUNE=HOST) " +-
                   "/ARCHITECTURE=HOST"
$    ENDIF
$ ENDIF
$ IF F$TRNLNM("WASD_BUILD_DEFINES") .NES. "" -
     THEN CC_DEFINES = F$TRNLNM("WASD_BUILD_DEFINES")
$ IF DBUG .NES. ""
$ THEN
$    IF CC_DEFINES .NES. "" THEN CC_DEFINES = CC_DEFINES + ","
$    CC_DEFINES = CC_DEFINES + DBUG
$ ENDIF
$ IF SESOLA .NES. ""
$ THEN
$    IF CC_DEFINES .NES. "" THEN CC_DEFINES = CC_DEFINES + ","
$    CC_DEFINES = CC_DEFINES + "SESOLA"
$ ENDIF
$ IF CC_DEFINES .NES. "" THEN CC_DEFINES = CC_DEFINES + ","
$ CC_DEFINES = CC_DEFINES + WATCH_CAT + "," + WATCH_MOD + "," + WASD_ACME
$ IF WASD_GETSPI .NES. "" THEN CC_DEFINES = CC_DEFINES + "," + WASD_GETSPI
$ IF CC_DEFINES .NES. "" THEN CC_DEFINES = " /DEFINE=(" + CC_DEFINES + ")"
$!
$ WRITE SYS$OUTPUT "Building for ""''VMS_ARCH_NAME'"""
$!
$ IF SESOLA_FROM .NES. "" THEN WRITE SYS$OUTPUT SESOLA_FROM
$!
$ IF WASD_ARCH_NAME .EQS. "IA64"
$ THEN
$    CC_OPTIONS = "/DECC /STAND=RELAXED_ANSI /PREFIX=ALL /NAMES=AS_IS " +-
                  "''OPTIMIZE' ''COMPILELIST'''DEBUGQUAL'''WARN'"
$ ENDIF
$ IF WASD_ARCH_NAME .EQS. "AXP"
$ THEN
$    CC_OPTIONS = "/DECC /STAND=RELAXED_ANSI /PREFIX=ALL /NAMES=AS_IS " +-
                  "''OPTIMIZE' ''COMPILELIST'''DEBUGQUAL'''WARN'"
$ ENDIF
$ IF WASD_ARCH_NAME .EQS. "X86_64"
$ THEN
$    CC_OPTIONS = "/DECC /STAND=RELAXED_ANSI /PREFIX=ALL /NAMES=AS_IS " +-
                  "''OPTIMIZE' ''COMPILELIST'''DEBUGQUAL'''WARN'"
$ ENDIF
$!
$ IF FLOAT_IEEE 
$ THEN 
$    CC_OPTIONS = CC_OPTIONS + " /FLOAT=IEEE /IEEE=DENORM"
$ ELSE
$    CC_OPTIONS = CC_OPTIONS + " /FLOAT=D_FLOAT"
$ ENDIF
$!
$! (ensure redundant files are removed (independent for MB MMS builds)
$ @BUILD_CLEAN
$!
$ IF LINKONLY THEN GOTO LINK
$!
$! ***********
$! * COMPILE *
$! ***********
$!
$ SET NOON
$ SET VERIFY
$ IF JUST .NES. "" THEN GOTO 'JUST'
$!
$ DELETE 'WASD_OBJ_DIR'*.OBJ;*
$!
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ ADMIN:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Admin    Admin.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTH:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Auth     Auth.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHACME:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'AuthACME'ACME_OBJ'  AuthACME.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHAGENT:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'AuthAgent  AuthAgent.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHCACHE:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'AuthCACHE  AuthCache.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHACCESS:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'AuthAccess  AuthAccess.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHCONFIG:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'AuthConfig  AuthConfig.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHHTA:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'AuthHTA  AuthHTA.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHHTL:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'AuthHTL  AuthHTL.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHIDENT:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'AuthIdent  AuthIdent.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHTOKEN:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'AuthToken  AuthToken.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ AUTHVMS:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'AuthVMS  AuthVMS.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ BASE64:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'base64    base64.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ BASIC:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Basic    Basic.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ BODY:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Body      Body.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ CACHE:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Cache    Cache.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ CGI:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'CGI      CGI.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ CLI:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'CLI      CLI.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ CONFIG:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Config   Config.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ CONTROL: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Control  Control.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$!'f$VERIFY(0)
$!
$ DAV:
$ SET VERIFY
$ DAVCOPY:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'DAVCOPY   DAVcopy.c
$ IF JUST .NES. "" .AND. JUST .NES. "DAV" THEN GOTO ENDCOMPILE
$ DAVDELETE:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'DAVDELETE   DAVdelete.c
$ IF JUST .NES. "" .AND. JUST .NES. "DAV" THEN GOTO ENDCOMPILE
$ DAVLOCK:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'DAVLOCK   DAVlock.c
$ IF JUST .NES. "" .AND. JUST .NES. "DAV" THEN GOTO ENDCOMPILE
$ DAVMETA:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'DAVMETA   DAVmeta.c
$ IF JUST .NES. "" .AND. JUST .NES. "DAV" THEN GOTO ENDCOMPILE
$ DAVMOVE:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'DAVMOVE   DAVmove.c
$ IF JUST .NES. "" .AND. JUST .NES. "DAV" THEN GOTO ENDCOMPILE
$ DAVPROP:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'DAVPROP   DAVprop.c
$ IF JUST .NES. "" .AND. JUST .NES. "DAV" THEN GOTO ENDCOMPILE
$ DAVWEB:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'DAVWEB     DAVweb.c
$ IF JUST .NES. "" .AND. JUST .NES. "DAV" THEN GOTO ENDCOMPILE
$ DAVXML:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'DAVXML     DAVxml.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$!'f$VERIFY(0)
$!
$ SET VERIFY
$ DCL:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Dcl      Dcl.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ DCLMEMBUF: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'DCLmembuf DCLmembuf.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ DECNET:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'DECnet   DECnet.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ DESCR:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Descr    Descr.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ DICT:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Dict    Dict.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ DIR:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Dir      Dir.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ DIGEST:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Digest   Digest.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ ERROR:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Error    Error.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ FAO:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'FAO      FAO.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ FILE:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'File     File.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ GRAPH:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Graph    Graph.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ GZIP:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'gZIP      gZIP.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ HTADMIN: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'HTAdmin  HTAdmin.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ H2:  !all of HTTP/2 modules
$ HTTP2:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'HTTP2    HTTP2.c
$ IF JUST .NES. "" .AND. JUST .NES. "H2" THEN GOTO ENDCOMPILE
$ HTTP2NET:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'HTTP2net    HTTP2net.c
$ IF JUST .NES. "" .AND. JUST .NES. "H2" THEN GOTO ENDCOMPILE
$ HTTP2REQUEST:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'HTTP2request HTTP2request.c
$ IF JUST .NES. "" .AND. JUST .NES. "H2" THEN GOTO ENDCOMPILE
$ HTTP2WATCH:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'HTTP2watch HTTP2watch.c
$ IF JUST .NES. "" .AND. JUST .NES. "H2" THEN GOTO ENDCOMPILE
$ HPACK:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'HPACK    HPACK.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ HTTPD:   IF WASD_ARCH_NAME .EQS. "X86_64" THEN -
              DEFINE /USER DECC$TEXT_LIBRARY SYS$LIBRARY:SYS$LIB_C.TLB
$          CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'HTTPd    HTTPd.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ INCONFIG:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'InConfig InConfig.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ INSTANCE:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Instance    Instance.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ LOGGING: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Logging  Logging.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ MAPCON:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'MapCon   MapCon.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ MAPODS:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'MapOds   MapOds.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ MAPSET:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'MapSet   MapSet.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ MAPURL:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'MapUrl   MapUrl.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ MAPUSER:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'MapUser MapUser.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ MD5:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'MD5      MD5.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ METACON:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'MetaCon     MetaCon.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ MSG:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Msg      Msg.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ NET:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Net      Net.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ NETIO:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'NetIO  NetIO.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ NETREJECT: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'NetReject NetReject
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ ODS:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'ODS      ODS.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ PERSONA: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Persona  Persona.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ PROXIES:
$ PROXY:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Proxy    Proxy.c
$ IF JUST .NES. "" .AND JUST .NES. "PROXIES" THEN GOTO ENDCOMPILE
$ PROXYMAINT:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'ProxyMaint ProxyMaint.c
$ IF JUST .NES. "" .AND JUST .NES. "PROXIES" THEN GOTO ENDCOMPILE
$ PROXYNET:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'ProxyNet     ProxyNet.c
$ IF JUST .NES. "" .AND JUST .NES. "PROXIES" THEN GOTO ENDCOMPILE
$ PROXYSOCKS:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'ProxySocks  ProxySocks.c
$ IF JUST .NES. "" .AND JUST .NES. "PROXIES" THEN GOTO ENDCOMPILE
$ PROXYTUNNEL:  CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'ProxyTunnel ProxyTunnel.c
$ IF JUST .NES. "" .AND JUST .NES. "PROXIES" THEN GOTO ENDCOMPILE
$ PROXYVERIFY:    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'ProxyVerify ProxyVerify.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ PUT:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Put      Put.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ REDIRECT: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Redirect  Redirect.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ REGEX:
$    REGEX_DEFINES = CC_DEFINES - ")" + ",STDC_HEADERS,REGEX_MALLOC)"
$    CC 'CC_OPTIONS''REGEX_DEFINES' /OBJ='WASD_OBJ_DIR'RegEx     RegEx.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ REQUEST: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Request  Request.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ RESPONSE:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'RESPONSE    Response.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ SERVICE:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Service      Service.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ SHA1:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'SHA1    SHA1.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ SSI:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'SSI      SSI.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$!
$ SSL:
$!'f$VERIFY(0)
$ SESOLA:
$ SESOLACME:
$ SESOLACACHE:
$ SESOLACERT:
$ SESOLACGI:
$ SESOLACLIENT:
$ SESOLAMKCERT:
$ SESOLANET:
$ SESOLANETIO:
$ IF SESOLA .NES. ""
$ THEN
$    HOPENSSL = F$TRNLNM("WASD_OPENSSL","LNM$PROCESS")
$    SSL_CC_DEFINES = CC_DEFINES - ")" + ",HOPENSSL=""""""''HOPENSSL'"""""")"
$    SSL321_CC_DEFINES = SSL_CC_DEFINES - ")" + ",SESOLA321=1)"
$ ENDIF
$ IF JUST .NES. "" THEN GOTO 'JUST'_
$ SSL_:
$ SET VERIFY
$ SESOLA_: CC 'CC_OPTIONS''SSL_CC_DEFINES''SESOLA_WARN' -
              /OBJ='WASD_OBJ_DIR'Sesola'SESOLA_OBJ' Sesola.c
$          SES_CC_OPT = CC_OPTIONS - "/LIST" - "/MACHINE"
$          CC 'SES_CC_OPT' /NAMES=AS_IS'SSL321_CC_DEFINES''SESOLA_WARN' -
              /OBJ='WASD_OBJ_DIR'Sesola321'SESOLA_OBJ' Sesola.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLACME_: CC 'CC_OPTIONS''SSL_CC_DEFINES''SESOLA_WARN' -
              /OBJ='WASD_OBJ_DIR'SesolaCME'SESOLA_OBJ' SesolaCME.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLACACHE_: CC 'CC_OPTIONS''SSL_CC_DEFINES''SESOLA_WARN' -
                /OBJ='WASD_OBJ_DIR'SesolaCache'SESOLA_OBJ' SesolaCache.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLACGI_: CC 'CC_OPTIONS''SSL_CC_DEFINES''SESOLA_WARN' -
              /OBJ='WASD_OBJ_DIR'SesolaCGI'SESOLA_OBJ' SesolaCGI.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLACERT_: CC 'CC_OPTIONS''SSL_CC_DEFINES''SESOLA_WARN' -
              /OBJ='WASD_OBJ_DIR'SesolaCERT'SESOLA_OBJ' SesolaCERT.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLACLIENT_: CC 'CC_OPTIONS''SSL_CC_DEFINES''SESOLA_WARN' -
                 /OBJ='WASD_OBJ_DIR'SesolaClient'SESOLA_OBJ' SesolaClient.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLAMKCERT_: CC 'CC_OPTIONS''SSL_CC_DEFINES''SESOLA_WARN' -
                 /OBJ='WASD_OBJ_DIR'SesolaMkCert'SESOLA_OBJ' SesolaMkCert.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLANET_: CC 'CC_OPTIONS''SSL_CC_DEFINES''SESOLA_WARN' -
              /OBJ='WASD_OBJ_DIR'SesolaNet'SESOLA_OBJ' SesolaNet.c
$ IF JUST .NES. "" .AND. JUST .NES. "SSL" THEN GOTO ENDCOMPILE
$ SESOLANETIO_: CC 'CC_OPTIONS''SSL_CC_DEFINES''SESOLA_WARN' -
                /OBJ='WASD_OBJ_DIR'SesolaNetIo'SESOLA_OBJ' SesolaNetIo.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ 
SET VERIFY
$!
$ STMLF:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'StmLF    StmLF.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ STRDSC:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'StrDsc   StrDsc.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ STRNG:   CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Strng    Strng.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ SUPPORT: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Support  Support.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ SYSLOG: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'syslog  SysLog.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ SYSPLUS: CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'sysPLUS  sysPLUS.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ TCPIP:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'TcpIp      TcpIp.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ TCPIPALT:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'TcpIpAlt  TcpIpAlt.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ TCPIP6:   
$ IF TCPIP6_STUB
$ THEN
$    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Tcpip6_stub  TcpIp6.c
$ ELSE
$    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Tcpip6 TcpIp6.c
$ ENDIF
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ THROTTLE:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Throttle  Throttle.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ UPD:     CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'Upd      Upd.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ VM:      CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'VM       VM.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ WATCH:   
$    WATCHFUNC_CC = CC_OPTIONS + CC_DEFINES
$    @BUILD_WATCHFUNC
$!   'F$VERIFY(1)
$    CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'WATCH  WATCH.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$ WEBSOCK:      CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'WebSock   WebSock.c
$ IF JUST .NES. "" THEN GOTO ENDCOMPILE
$!
$ VERSION: DATETIME = F$TIME()
$ IF F$EXTRACT(0,1,DATETIME) .EQS. " " THEN DATETIME = F$EXTRACT(1,99,DATETIME)
$ CC_DEFINES = CC_DEFINES - ")" + ",BUILD_DATETIME=""""""''DATETIME'"""""")"
$ CC 'CC_OPTIONS''CC_DEFINES' /OBJ='WASD_OBJ_DIR'VERSION  Version.c
$!
$ ENDCOMPILE:
$! 'F$VERIFY(0)
$!
$ IF COMPILEONLY THEN GOTO FINISHED
$!
$! ********
$! * LINK *
$! ********
$!
$ LINK:
$!
$ SEARCH VERSION.H HTTPD_VERSION /OUTPUT=IMAGE_IDENT.LIS
$ OPEN /READ IMAGEIDENT IMAGE_IDENT.LIS
$ READ IMAGEIDENT IMAGE_IDENT
$ CLOSE IMAGEIDENT
$ DELETE /NOLOG /NOCONFIRM IMAGE_IDENT.LIS;*
$ IMAGE_IDENT = F$ELEMENT(1,"""",IMAGE_IDENT)
$ IF IMAGE_IDENT .EQS. "" .OR. IMAGE_IDENT .EQS. """" -
     THEN IMAGE_IDENT = "_UNKNOWN_"
$!
$ PROCEDURE = F$ENVIRONMENT("PROCEDURE")
$ PROCEDURE_DEV = F$PARSE(PROCEDURE,,,"DEVICE")
$ PROCEDURE_DIR = F$PARSE(PROCEDURE,,,"DIRECTORY")
$ LINK_OPT = PROCEDURE_DEV + PROCEDURE_DIR + "LINK_" + WASD_ARCH_NAME +".OPT"
$ IF F$TRNLNM("WASD_LINK_OPT","LNM$PROCESS") THEN CLOSE WASD_LINK_OPT
$ IF F$SEARCH("''LINK_OPT'") .NES. "" THEN DELETE /NOCONFIRM /NOLOG 'LINK_OPT';*
$!
$ OPEN /WRITE WASD_LINK_OPT 'LINK_OPT'
$ WRITE WASD_LINK_OPT "IDENT=""" + IMAGE_IDENT + """"
$ WRITE WASD_LINK_OPT "CASE_SENSITIVE=YES"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Admin"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Auth"
$ IF ACME_STUB
$    THEN WRITE WASD_LINK_OPT WASD_OBJ_DIR + "AuthACME" + ACME_OBJ
$    ELSE WRITE WASD_LINK_OPT WASD_OBJ_DIR + "AuthACME"
$ ENDIF
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "AuthAgent"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "AuthCache"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "AuthAccess"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "AuthConfig"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "AuthHTA"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "AuthHTL"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "AuthIdent"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "AuthToken"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "AuthVMS"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Basic"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "BASE64"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Body"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Cache"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "CGI"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "CLI"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Config"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Control"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "DAVcopy"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "DAVdelete"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "DAVlock"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "DAVmeta"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "DAVmove"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "DAVprop"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "DAVweb"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "DAVxml"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Dcl"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "DCLmembuf"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "DECnet"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Descr"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Dict"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Dir"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Digest"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Error"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "FAO"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "File"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Graph"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "gZIP"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "HTAdmin"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "HTTP2"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "HTTP2net"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "HTTP2request"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "HTTP2watch"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "HTTPd"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "HPACK"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "InConfig"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Instance"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Logging"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "MapCon"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "MapOds"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "MapSet"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "MapUrl"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "MapUser"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "MD5"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "MetaCon"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Msg"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Net"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "NetIO"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "NetReject"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "ODS"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Persona"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Proxy"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "ProxyMaint"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "ProxyNet"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "ProxySocks"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "ProxyTunnel"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "ProxyVerify"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Put"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Redirect"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "RegEx"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Request"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Response"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Service"
$ IF SESOLA .NES. ""
$ THEN
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Sesola''SESOLA_OBJ'"
$    IF F$EXTRACT(0,9,SESOLA) .EQS. "SESOLA111"
$    THEN
$       WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Sesola321''SESOLA_OBJ'"
$    ENDIF
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaCME''SESOLA_OBJ'"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaCache''SESOLA_OBJ'"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaCert''SESOLA_OBJ'"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaCGI''SESOLA_OBJ'"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaClient''SESOLA_OBJ'"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaMkCert''SESOLA_OBJ'"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaNet''SESOLA_OBJ'"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaNetIo''SESOLA_OBJ'"
$ ELSE
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Sesola"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaCME"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaCache"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaCert"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaCGI"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaClient"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaMkCert"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaNet"
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SesolaNetIo"
$ ENDIF
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SHA1"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SSI"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "StmLF"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "StrDsc"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Strng"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Support"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "SysLog"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "sysPLUS"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "TCPIP"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "TCPIPalt"
$ IF TCPIP6_STUB
$ THEN
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "TCPIP6_stub"
$ ELSE
$    WRITE WASD_LINK_OPT WASD_OBJ_DIR + "TCPIP6"
$ ENDIF
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Throttle"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Upd"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Version"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "VM"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "Watch"
$ WRITE WASD_LINK_OPT WASD_OBJ_DIR + "WebSock"
$ IF WEBDAV_EXPAT
$ THEN
$    EXPAT_WASD_OBJ_DIR = "[-.EXPAT." + (WASD_OBJ_DIR  - "[.")
$    WRITE WASD_LINK_OPT EXPAT_WASD_OBJ_DIR + "XMLPARSE"
$    WRITE WASD_LINK_OPT EXPAT_WASD_OBJ_DIR + "XMLROLE"
$    WRITE WASD_LINK_OPT EXPAT_WASD_OBJ_DIR + "XMLTOK"
$ ENDIF
$ IF SESOLA .NES. ""
$ THEN
$    IF F$LOCATE("/SHARE",SESOLA) .LT. F$LENGTH(SESOLA)
$    THEN
$       WRITE WASD_LINK_OPT "SYMBOL=SESOLA_SHARE,1"
$    ELSE
$       WRITE WASD_LINK_OPT "SYMBOL=SESOLA_SHARE,0"
$    ENDIF
$    WRITE WASD_LINK_OPT F$TRNLNM("WASD_LIBSSL")
$    WRITE WASD_LINK_OPT F$TRNLNM("WASD_LIBCRYPTO")
$ ENDIF
$!
$! (fallback for SYSPLUS.C)
$ IF WASD_GETSPI .NES. "" THEN WRITE WASD_LINK_OPT "SYS$SHARE:SPISHR.EXE/SHARE"
$!
$ CLOSE WASD_LINK_OPT
$!
$ TYPE 'LINK_OPT'
$!
$ SET ON
$!
$ IF WASD_ARCH_NAME .EQS. "X86_64"
$ THEN
$    LINK /SYSEXE 'LINKMAP' 'TRACEQUAL' 'DEBUGQUAL'-
          /EXECUTABLE=WASD_EXE:HTTPD'SESOLA_EXE'.EXE -
          'LINK_OPT'/OPTIONS
$ ELSE
$    LINK 'LINKMAP' 'TRACEQUAL' 'DEBUGQUAL'-
          /EXECUTABLE=WASD_EXE:HTTPD'SESOLA_EXE'.EXE -
          'LINK_OPT'/OPTIONS
$ ENDIF
$!
$!'F$VERIFY(0)
$ DELETE /NOCONFIRM /NOLOG 'LINK_OPT';*
$ PURGE /LOG 'WASD_OBJ_DIR' /KEEP=3
$!
$! ************
$! * FINISHED *
$! ************
$!
$ ETIME = F$TIME()
$!! WRITE SYS$OUTPUT "DURATION:" + F$DELTA_TIME(STIME,ETIME)
$ FINISHED:  !'F$VERIFY(0)
$ SET DEFAULT 'PREVDEFAULT'
$ CALL DEASSIGN_WORKING_LOGICAL_NAMES
$!
$! ***************
$! * SUBROUTINES *
$! ***************
$!
$!-----------------------------------------------------------------------------
$ DEASSIGN_WORKING_LOGICAL_NAMES: SUBROUTINE
$!
$ IF F$TRNLNM("SSLROOT","LNM$PROCESS") .NES. "" -
     THEN DEASSIGN /PROCESS SSLROOT
$ IF F$TRNLNM("OPENSSL","LNM$PROCESS") .NES. "" -
     THEN DEASSIGN /PROCESS OPENSSL
$ IF F$TRNLNM("WASD_SSLROOT","LNM$PROCESS",1) .EQS. "*"
$ THEN
$!   (a local to BUILD_HTTPD_.COM definition)
$    IF F$TRNLNM("WASD_SSLROOT","LNM$PROCESS") .NES. "" -
        THEN DEASSIGN /PROCESS WASD_SSLROOT
$    IF F$TRNLNM("WASD_OPENSSL","LNM$PROCESS") .NES. "" -
        THEN DEASSIGN /PROCESS WASD_OPENSSL
$    IF F$TRNLNM("WASD_LIBSSL","LNM$PROCESS") .NES. "" -
        THEN DEASSIGN /PROCESS WASD_LIBSSL
$    IF F$TRNLNM("WASD_LIBCRYPTO","LNM$PROCESS") .NES. "" -
        THEN DEASSIGN /PROCESS WASD_LIBCRYPTO
$ ENDIF
$!
$ ENDSUBROUTINE
$!-----------------------------------------------------------------------------
$ CHECK_FOR_SSL: SUBROUTINE
$! p1 provides a command-line parameter
$ SET SYMBOL/SCOPE=LOCAL
$!
$ IF P1 .EQS. "SSL=0" THEN P1 = "SSL0"
$ IF P1 .EQS. "SSL=1" THEN P1 = "SSL1"
$ IF P1 .EQS. "SSL111=1" THEN P1 = "SSL111"
$ IF P1 .EQS. "SSL=3" THEN P1 = "SSL3"
$ IF P1 .EQS. "SSL3=1" THEN P1 = "SSL3"
$ IF P1 .EQS. "SSL=31" THEN P1 = "SSL31"
$ IF P1 .EQS. "SSL31=1" THEN P1 = "SSL31"
$ IF P1 .EQS. "SSL=32" THEN P1 = "SSL32"
$ IF P1 .EQS. "SSL32=1" THEN P1 = "SSL32"
$!
$ IF P1 .EQS. "SSL" .OR. -
     P1 .EQS. "SSL=0" .OR. -
     P1 .EQS. "SSL0" .OR. -  !(special case)
     P1 .EQS. "SSL111" .OR. -
     P1 .EQS. "SSL111_SHR" .OR. -
     P1 .EQS. "SSL111_SHR=1" .OR. -
     P1 .EQS. "SSL3" .OR. -
     P1 .EQS. "SSL3_SHR" .OR. -
     P1 .EQS. "SSL3_SHR=1" .OR. -
     P1 .EQS. "SSL31" .OR. -
     P1 .EQS. "SSL31_SHR" .OR. -
     P1 .EQS. "SSL31_SHR=1"
     P1 .EQS. "SSL32" .OR. -
     P1 .EQS. "SSL32_SHR" .OR. -
     P1 .EQS. "SSL32_SHR=1"
$ THEN
$    @WASD_ROOT:[INSTALL]SSL_DETECT_CANCEL.COM
$    CALL DEASSIGN_WORKING_LOGICAL_NAMES
$ ELSE
$    EXIT 1
$ ENDIF
$!
$ IF P1 .EQS. "SSL111" .OR. -
     P1 .EQS. "SSL111=1"
$ THEN
$    CALL CHECK_SSL_ROOT "SSL111$ROOT"
$    DEFINE /PROCESS /NOLOG WASD_SSLROOT "SSL111$ROOT","*"
$    DEFINE /PROCESS /NOLOG WASD_OPENSSL "SSL111$ROOT:[INCLUDE]"
$    DEFINE /PROCESS /NOLOG WASD_LIBSSL "SSL111$ROOT:[LIB]SSL111$LIBSSL32.OLB/LIBRARY"
$    DEFINE /PROCESS /NOLOG WASD_LIBCRYPTO "SSL111$ROOT:[LIB]SSL111$LIBCRYPTO32.OLB/LIBRARY"
$ ENDIF
$!
$ IF P1 .EQS. "SSL111_SHR" .OR. -
     P1 .EQS. "SSL111_SHR=1"
$ THEN
$    CALL CHECK_SSL_ROOT "SSL111$ROOT"
$    DEFINE /PROCESS /NOLOG WASD_SSLROOT "SSL111$ROOT","*"
$    DEFINE /PROCESS /NOLOG WASD_OPENSSL "SSL111$ROOT:[INCLUDE]"
$    DEFINE /PROCESS /NOLOG WASD_LIBSSL "SYS$LIBRARY:SSL111$LIBSSL_SHR32.EXE/SHARE"
$    DEFINE /PROCESS /NOLOG WASD_LIBCRYPTO "SYS$LIBRARY:SSL111$LIBCRYPTO_SHR32.EXE/SHARE"
$ ENDIF
$!
$ IF P1 .EQS. "SSL3" .OR. -
     P1 .EQS. "SSL3=1"
$ THEN
$    CALL CHECK_SSL_ROOT "SSL3$ROOT"
$    DEFINE /PROCESS /NOLOG WASD_SSLROOT "SSL3$ROOT","*"
$    DEFINE /PROCESS /NOLOG WASD_OPENSSL "SSL3$ROOT:[INCLUDE]"
$    DEFINE /PROCESS /NOLOG WASD_LIBSSL "SSL3$ROOT:[LIB]SSL3$LIBSSL32.OLB/LIBRARY"
$    DEFINE /PROCESS /NOLOG WASD_LIBCRYPTO "SSL3$ROOT:[LIB]SSL3$LIBCRYPTO32.OLB/LIBRARY"
$ ENDIF
$!
$ IF P1 .EQS. "SSL31" .OR. -
     P1 .EQS. "SSL31=1"
$ THEN
$    CALL CHECK_SSL_ROOT "SSL31$ROOT"
$    DEFINE /PROCESS /NOLOG WASD_SSLROOT "SSL31$ROOT","*"
$    DEFINE /PROCESS /NOLOG WASD_OPENSSL "SSL31$ROOT:[INCLUDE]"
$    DEFINE /PROCESS /NOLOG WASD_LIBSSL "SSL31$ROOT:[LIB]SSL31$LIBSSL32.OLB/LIBRARY"
$    DEFINE /PROCESS /NOLOG WASD_LIBCRYPTO "SSL31$ROOT:[LIB]SSL31$LIBCRYPTO32.OLB/LIBRARY"
$ ENDIF
$!
$ IF P1 .EQS. "SSL32" .OR. -
     P1 .EQS. "SSL32=1"
$ THEN
$    CALL CHECK_SSL_ROOT "SSL32$ROOT"
$    DEFINE /PROCESS /NOLOG WASD_SSLROOT "SSL32$ROOT","*"
$    DEFINE /PROCESS /NOLOG WASD_OPENSSL "SSL32$ROOT:[INCLUDE]"
$    DEFINE /PROCESS /NOLOG WASD_LIBSSL "SSL32$ROOT:[LIB]SSL32$LIBSSL32.OLB/LIBRARY"
$    DEFINE /PROCESS /NOLOG WASD_LIBCRYPTO "SSL32$ROOT:[LIB]SSL32$LIBCRYPTO32.OLB/LIBRARY"
$ ENDIF
$!
$ IF P1 .EQS. "SSL3_SHR" .OR. -
     P1 .EQS. "SSL3_SHR=1"
$ THEN
$    CALL CHECK_SSL_ROOT "SSL3$ROOT"
$    DEFINE /PROCESS /NOLOG WASD_SSLROOT "SSL3$ROOT","*"
$    DEFINE /PROCESS /NOLOG WASD_OPENSSL "SSL3$ROOT:[INCLUDE]"
$    DEFINE /PROCESS /NOLOG WASD_LIBSSL "SYS$LIBRARY:SSL3$LIBSSL_SHR32.EXE/SHARE"
$    DEFINE /PROCESS /NOLOG WASD_LIBCRYPTO "SYS$LIBRARY:SSL3$LIBCRYPTO_SHR32.EXE/SHARE"
$ ENDIF
$!
$ IF P1 .EQS. "SSL31_SHR" .OR. -
     P1 .EQS. "SSL31_SHR=1"
$ THEN
$    CALL CHECK_SSL_ROOT "SSL31$ROOT"
$    DEFINE /PROCESS /NOLOG WASD_SSLROOT "SSL31$ROOT","*"
$    DEFINE /PROCESS /NOLOG WASD_OPENSSL "SSL31$ROOT:[INCLUDE]"
$    DEFINE /PROCESS /NOLOG WASD_LIBSSL "SYS$LIBRARY:SSL31$LIBSSL_SHR32.EXE/SHARE"
$    DEFINE /PROCESS /NOLOG WASD_LIBCRYPTO "SYS$LIBRARY:SSL31$LIBCRYPTO_SHR32.EXE/SHARE"
$ ENDIF
$!
$ IF P1 .EQS. "SSL32_SHR" .OR. -
     P1 .EQS. "SSL32_SHR=1"
$ THEN
$    CALL CHECK_SSL_ROOT "SSL32$ROOT"
$    DEFINE /PROCESS /NOLOG WASD_SSLROOT "SSL32$ROOT","*"
$    DEFINE /PROCESS /NOLOG WASD_OPENSSL "SSL32$ROOT:[INCLUDE]"
$    DEFINE /PROCESS /NOLOG WASD_LIBSSL "SYS$LIBRARY:SSL32$LIBSSL_SHR32.EXE/SHARE"
$    DEFINE /PROCESS /NOLOG WASD_LIBCRYPTO "SYS$LIBRARY:SSL32$LIBCRYPTO_SHR32.EXE/SHARE"
$ ENDIF
$!
$ IF P1 .EQS. "SSL0"
$ THEN
$! (special case for testing build against non-VSI OpenSSLs)
$    IF F$SEARCH("''WASD_OBJ_DIR'OSSL$LIBSSL32.OLB") .NES. "" .AND. -
        F$SEARCH("''WASD_OBJ_DIR'OSSL$LIBCRYPTO32.OLB") .NES. ""
$    THEN
$       DEFINE /PROCESS /NOLOG WASD_SSLROOT "SSL0$ROOT","*"
$       DEFINE /PROCESS /NOLOG WASD_OPENSSL "SSL0$ROOT:[INCLUDE.OPENSSL]"
$       DEFINE /PROCESS /NOLOG WASD_LIBSSL "''WASD_OBJ_DIR'OSSL$LIBSSL32.OLB/LIBRARY"
$       DEFINE /PROCESS /NOLOG WASD_LIBCRYPTO "''WASD_OBJ_DIR'OSSL$LIBCRYPTO32.OLB/LIBRARY"
$    ELSE
$       COPY SSL0$ROOT:[INCLUDE.OPENSSL]OPENSSLCONF.H SSL0$ROOT:[INCLUDE]
$       CALL CHECK_SSL_ROOT "SSL0$ROOT"
$       DELETE SSL0$ROOT:[INCLUDE]OPENSSLCONF.H;*
$       SSL0ROOT = F$TRNLNM("SSL0$ROOT") - ".]"
$       DEFINE /PROCESS /NOLOG WASD_SSLROOT "SSL0$ROOT","*"
$       DEFINE /PROCESS /NOLOG WASD_OPENSSL "SSL0$ROOT:[INCLUDE.OPENSSL]"
$       DEFINE /PROCESS /NOLOG WASD_LIBSSL "SSL0$ROOT:[000000]OSSL$LIBSSL32.OLB/LIBRARY"
$       DEFINE /PROCESS /NOLOG WASD_LIBCRYPTO "SSL0$ROOT:[000000]OSSL$LIBCRYPTO32.OLB/LIBRARY"
$    ENDIF
$ ENDIF
$!
$ EXIT 1
$!
$ ENDSUBROUTINE
$!-----------------------------------------------------------------------------
$ CHECK_SSL_ROOT: SUBROUTINE
$! p1 is the OpenSSL root logical name
$!
$ SSL_ROOT = F$TRNLNM(P1)
$ IF SSL_ROOT .EQS. "" THEN SSL_ROOT = "BLAH:[BLAH.]"
$!
$ IF F$SEARCH("''P1':[000000]*.*") .EQS. ""
$ THEN
$    TYPE SYS$INPUT

  ***********************************
  *  OpenSSL directory not located  *
  ***********************************

$    CALL DEASSIGN_WORKING_LOGICAL_NAMES
$    EXIT 44
$ ENDIF
$!
$ IF F$SEARCH("''P1':[INCLUDE]OPENSSLCONF.H") .EQS. ""
$ THEN
$    TYPE SYS$INPUT

  ******************************************
  *  OpenSSL OPENSSLCONF.H file not found  *
  ******************************************

$    CALL DEASSIGN_WORKING_LOGICAL_NAMES
$    EXIT 44
$ ENDIF
$!
$ EXIT 1
$!
$ ENDSUBROUTINE
$!-----------------------------------------------------------------------------
