$!-----------------------------------------------------------------------------
$! BUILD_PHPRTE.COM
$!
$! Copyright (C) 2002-2024 Mark G. Daniel
$! This package comes with ABSOLUTELY NO WARRANTY.
$! This is free software, and you are welcome to redistribute it.
$!
$! Build the WASD CGI/CGIplus/RTE engine for PHP.
$!
$! P1 == LINK (empty) or BUILD
$!
$! 02-AUG-2024  MGD  adapt for VSI PHP beginning with V8.0
$! 27-JAN-2012  MGD  add DCLSYMBOL.C extension build
$!                   remove CRTL-specific 702 build
$! 25-MAY-2009  MGD  v1.4.0 image identification
$! 26-NOV-2005  MGD  V1.3.3 build changes for CSWS PHP 1.3 code base
$! 14-NOV-2004  MGD  v1.2.3 add P2 for CRTL-specific build
$! 14-FEB-2004  MGD  modified for building against CSWS PHP v1.2 source
$! 26-DEC-2002  MGD  modified for building against CSWS PHP v1.1 source
$! 28-JAN-2002  MGD  corrected
$! 14-JAN-2002  MGD  initial
$!-----------------------------------------------------------------------------
$!
$ SAY = "WRITE SYS$OUTPUT"
$!
$ SAY ""
$ SAY "Building ""PHPRTE"" for ""''F$GETSYI("ARCH_NAME")'"" architecture"
$!
$ SYI_VERSION = F$GETSYI("VERSION")
$ VMS_VERSION = F$INTEGER(F$EXTRACT(1,1,SYI_VERSION)) * 100 +-
                F$INTEGER(F$EXTRACT(3,1,SYI_VERSION)) * 10
$ IF F$EXTRACT(4,1,SYI_VERSION) .EQS. "-" -
     THEN VMS_VERSION = VMS_VERSION + F$INTEGER(F$EXTRACT(5,1,SYI_VERSION))
$ DATETIME = F$TIME()
$ IF F$EXTRACT(0,1,DATETIME) .EQS. " " THEN DATETIME = F$EXTRACT(1,99,DATETIME)
$!
$ IF P2 .EQS. "DIST"
$ THEN
$    @BUILD_PHPRTE.COM BUILD
$    EXIT
$ ENDIF
$ CC_DEFINES = " /DEFINE=(BUILD_DATETIME=""""""''DATETIME'"""""")"
$!
$ IF P1 .EQS. "BUILD" .OR. P1 .EQS. "COMPILE"
$ THEN
$!   (need header files)
$    IF F$SEARCH("PHP$ROOT:[INCLUDE]MAIN.DIR") .NES. ""
$    THEN
$       PHP_ROOT = F$TRNLNM("PHP$ROOT",,"NO_CONCEAL") - "][" - ".]"
$       PHP_INCLUDE = "''PHP_ROOT'.INCLUDE.]"
$       DEFINE /PROCESS /TRANSLATION=CONCEALED PHP_INCLUDE 'PHP_INCLUDE'
$    ENDIF
$    SAY "Using PHP_INCLUDE defined as ''f$TRNLNM("PHP_INCLUDE")'"
$ ENDIF
$!
$ PHPSHR = F$TRNLNM("PHP$SHR","LNM$SYSTEM")
$ PHPRTESHR = F$TRNLNM("PHPRTESHR","LNM$SYSTEM")
$ IF PHPSHR .EQS. "" .AND. PHPRTESHR .EQS. ""
$ THEN
$    TYPE SYS$INPUT

        ************************************************************
        *  NEITHER LOGICAL NAME 'PHPSHR' OR 'PHPRTESHR' DEFINED!  *
        ************************************************************

Either one of these logical names needs to be available to locate the PHP
sharable image.  Please read build instructions and execute PHP_STARTUP.COM
procedure before attempting to build.

$    EXIT
$ ENDIF
$!
$ PHP_ROOT = F$TRNLNM("PHP_ROOT","LNM$PROCESS")
$ IF PHP_ROOT .NES. "" THEN DEASSIGN /PROCESS PHP_ROOT
$!
$ IF PHPRTESHR .NES. "" .AND. F$SEARCH(PHPRTESHR) .EQS. ""
$ THEN
$    TYPE SYS$INPUT

               **********************************************
               *  CANNOT FIND 'PHPRTESHR' SHAREABLE IMAGE  *
               **********************************************

Check definition of logical name PHPRTESHR.

$    SHOW LOGICAL PHPRTESHR
$    SAY ""
$    EXIT
$ ENDIF
$!
$ IF PHPSHR .NES. "" .AND. F$SEARCH(PHPSHR) .EQS. ""
$ THEN
$    TYPE SYS$INPUT

                 ******************************************
                 *  CANNOT FIND 'PHPSHR' SHAREABLE IMAGE  *
                 ******************************************

Check definition of logical name PHPSHR.

$    SHOW LOGICAL PHPRTESHR
$    SAY ""
$    EXIT
$ ENDIF
$!
$ IF PHP_ROOT .NES. "" -
     THEN DEFINE /PROCESS /TRANSLATION=CONCEALED PHP_ROOT 'PHP_ROOT'
$!
$ ARCH_NAME = F$EDIT(F$GETSYI("ARCH_NAME"),"UPCASE")
$ IF ARCH_NAME .EQS. "ALPHA" THEN ARCH_NAME = "AXP"
$!
$ CC_OPTIONS = "/DECC /OPTIMIZE /PREFIX=ALL /NAMES=AS_IS"
$!
$ PREVIOUS_DEFAULT = F$ENVIRONMENT("DEFAULT")
$ SET DEFAULT WASD_ROOT:[SRC.PHPRTE]
$!
$ IF F$SEARCH("OBJ_''ARCH_NAME'.DIR") .EQS. "" -
     THEN CREATE /DIR [.OBJ_'ARCH_NAME']
$ OBJECT_DIR = "[.OBJ_''ARCH_NAME']"
$!
$ IF P1 .EQS. "BUILD" .OR. P1 .EQS. "COMPILE"
$ THEN
$!
$    DEFINE /PROCESS MAIN PHP_INCLUDE:[MAIN]
$    DEFINE /PROCESS STREAMS PHP_INCLUDE:[MAIN.STREAMS]
$    DEFINE /PROCESS TSRM PHP_INCLUDE:[TSRM]
$    DECC_SYSTEM_INCLUDE = "PHP_INCLUDE:[EXT.STANDARD], " +-
        "PHP_INCLUDE:[MAIN], PHP_INCLUDE:[TSRM], PHP_INCLUDE:[ZEND]"
$    DEFINE /PROCESS DECC$SYSTEM_INCLUDE 'DECC_SYSTEM_INCLUDE'
$!
$    IF F$SEARCH("DECC$SYSTEM_INCLUDE:PHP.H") .EQS. ""
$    THEN
$       TYPE SYS$INPUT

                  *****************************************
                  *  CANNOT FIND 'PHP.H' IN INCLUDE PATH  *
                  *****************************************

$       SHOW LOGICAL DECC$SYSTEM_INCLUDE
$       SAY ""
$       EXIT
$    ENDIF
$    SAY ""
$    SET NOON
$    SET VERIFY
$ CC 'CC_OPTIONS''CC_DEFINES' /OBJECT='OBJECT_DIR'PHPRTE PHPRTE
$ CC 'CC_OPTIONS' /OBJECT='OBJECT_DIR'DCLSYMBOL DCLSYMBOL
$!   'F$VERIFY(0)
$    CC_STATUS = $STATUS
$    CC_SEVERITY = $SEVERITY
$    IF .NOT. CC_SEVERITY THEN EXIT 'CC_STATUS'
$    SET ON
$!
$    IF F$TRNLNM("PHP_INCLUDE_DIR","LNM$PROCESS") .NES. "" -
        THEN DEASSIGN /PROCESS PHP_INCLUDE_DIR
$!
$ ENDIF
$!
$ IF P1 .EQS. "" .OR. P1 .EQS. "BUILD" .OR. P1 .EQS. "LINK"
$ THEN
$!
$    SET NOON
$    IF PHPRTESHR .EQS. "" THEN PHPRTESHR = PHPSHR
$    DEFINE /PROCESS PHPRTESHR 'PHPRTESHR'
$    SAY "Linking against shareable image ''F$TRNLNM("PHPRTESHR")'"
$    SET VERIFY
$ LINK /EXECUTABLE=WASD_EXE:PHPRTE.EXE -
[.OBJ_'ARCH_NAME']PHPRTE.OBJ, -
SYS$INPUT:/OPTIONS 
PHP$SHR/SHARE
$ LINK /SHARE /EXECUTABLE=[.OBJ_'ARCH_NAME']PHP_DCLSYMBOL.EXE -
[.OBJ_'ARCH_NAME']DCLSYMBOL.OBJ, -
SYS$INPUT:/OPTIONS 
PHP$SHR/SHARE
$!   'F$VERIFY(0)
$    DEASSIGN /PROCESS PHPRTESHR
$    SET ON
$!
$ ENDIF
$!
$ PURGE /NOLOG 'OBJECT_DIR'
$ SAY ""
$!
$ IF F$TRNLNM("MAIN","LNM$PROCESS") .NES. "" THEN DEASSIGN /PROCESS MAIN
$ IF F$TRNLNM("STREAMS","LNM$PROCESS") .NES. "" THEN DEASSIGN /PROCESS STREAMS
$ IF F$TRNLNM("TSRM","LNM$PROCESS") .NES. "" THEN DEASSIGN /PROCESS TSRM
$ IF F$TRNLNM("DECC$SYSTEM_INCLUDE","LNM$PROCESS") .NES. "" THEN DEASSIGN /PROCESS DECC$SYSTEM_INCLUDE
$!
$ IF F$TYPE(PHP_INCLUDE) .NES. "" THEN DEASSIGN /PROCESS PHP_INCLUDE
$!
$ SET DEFAULT 'PREVIOUS_DEFAULT'
$!-----------------------------------------------------------------------------
