O /*****************************************************************************/  /**                                    tips.js  : Tooltips, includes both the tooltip code and the tip text.    	 COPYRIGHT 	 --------- % Copyright (C) 2014-2018 Mark G.Daniel 0 This program, comes with ABSOLUTELY NO WARRANTY.G This is free software, and you are welcome to redistribute it under the N conditions of the GNU GENERAL PUBLIC LICENSE, version 3, or any later version.# http://www.gnu.org/licenses/gpl.txt      VERSION  -------  05-MAR-2014  MGD  initial  */O /*****************************************************************************/   E var alam_ToolTipDisabled = false,  // set to true to disable tooltips +     alam_ToolTipDelay = 800,       // mSecs +     alam_ToolTipOutDelay = 200;    // mSecs   
 //////////
 // TIPS //
 //////////   function alamToolTipInit ()  { (    if (alam_ToolTipArray.length) return;      /////////////    // control //    /////////////  ;    alamToolTipAdd('controlCollect','Collect server data.');   "    alamToolTipAdd('controlUpdate',K 'Update displayed data. Deselecting this option allows the displayed data \ D to examined without change while maintaining collection for update \ when reselected.');   "    alamToolTipAdd('controlAlerts',G 'Display alerts. Normally enabled but can be disabled if overloaded.');   G    alamToolTipAdd('controlDetail','Display additional server detail.');        alamToolTipAdd('controlTips',? '<i style=\'font-size:120%;\'>These</i>&thinsp;&nbsp;things.');   #    alamToolTipAdd('controlHistory', @ 'Display activity history (line) graphs, 5 minutes by default, \ 15 minutes selectable.');   E    alamToolTipAdd('controlInstance', 'Display server process data.');   #    alamToolTipAdd('controlMinutes', A 'Store and display 5 (default) or 15 minutes of activity data.');      8    alamToolTipAdd('controlProxy','Display proxy data.');  L    alamToolTipAdd('controlRequest','Display the latest request processed.');  "    alamToolTipAdd('controlScript',0 'Display DCL and DECnet based scripting data.');  E    alamToolTipAdd('controlStatus','Display instance status report.');   :    alamToolTipAdd('controlWebDav','Display WebDAV data.');      /////////////    // summary //    /////////////      alamToolTipAdd('sumConnect', 7 'Current network connections, then peak, then total.');       alamToolTipAdd('sumProcess', < 'Current requests being processed, then peak, then total.');  8    alamToolTipAdd('sumBytesRx','Total bytes received.');;    alamToolTipAdd('sumBytesTx','Total bytes transmitted.');       alamToolTipAdd('sumHTTP2', L 'HTTP/2 requests.  First value is current processing, then peak processed, \C and finally total processed. Percentage of total in parentheses.');       alamToolTipAdd('sumHTTP1', [ 'HTTP/1.1 and HTTP/1.0 requests.  First value is current processing, then peak processed, \ C and finally total processed. Percentage of total in parentheses.');       alamToolTipAdd('sumSSL', 0 'Secure Socket Layer (TLS) requests processed, \& percentage of total in parentheses.');  K    alamToolTipAdd('sumFile','Total requests that had a file transferred.'); M    alamToolTipAdd('sumScript','Total requests that had a script activated.');     alamToolTipAdd('sumProxy', P 'Total requests proxied in some fashion (i.e. explicit proxy, reverse proxy).');  K    alamToolTipAdd('sumWebDAV','Total requests involving a WebDAV action.');       alamToolTipAdd('sumOther', A 'Total requests not involving file transfer, script activation, \ C or proxy access (e.g. directory listing, server administration).');        alamToolTipAdd('sumThrottle',K 'Throttled requests.  First value is total number throttled, then queued, \ B and finally busy.  Percentage of total for each in parentheses.');      // status  8    alamToolTipAdd('nn1','Total informational responses \: (e.g. 100 <i>continue</i>, 101 <i>upgrade required</i>), \& percentage of total in parentheses.');      alamToolTipAdd('nn2',G 'Total success responses (e.g. 200 <i>OK</i>, 204 <i>no content</i>), \ ' percentage of total in parentheses.');        alamToolTipAdd('nn3',; 'Total redirection responses (e.g. 302 <i>found here</i>, \ A 304 <i>not modified</i>), percentage of total in parentheses.');        alamToolTipAdd('nn4',= 'Total client error responses (e.g. 400 <i>bad request</i>, \ > 404 <i>not found</i>), percentage of total in parentheses.');       alamToolTipAdd('nn5',@ 'Total server error responses (e.g. 500 <i>internal error</i>, \H 503 <i>service unavailable</i>), percentage of total in parentheses.');       /////////////    // history //    /////////////  I    alamToolTipAdd('bar', 'Bar graphs display maximum, instantaneous and \ J average values (as applicable) for each collected datum.  The history of \J these values is displayed in line graphs opened using the <i>History</i> \ checkbox.');  5    alamToolTipAdd('bioHist','System buffered I/Os.');        alamToolTipAdd('connectHist',N 'Server network connections, where green is the total (including persistent) \1 and blue the number currently being processed.');       alamToolTipAdd('cpuHist',: 'System CPU consumed, where the green value is total CPU \, and the red value non-USER modes (S+E+K).');      alamToolTipAdd('diskHist', ; 'System disk operations (File Control Primitives - FCPs), \ ; where green is total (reads + writes) and red is writes.');       alamToolTipAdd('fileHist', - 'Server file requests, where green is total \ H and blue is not modified (304 response, with no content transferred).');      alamToolTipAdd('netHist',2 'System network interface (NI) bytes per second, \N where green is the total of system traffic and blue is server (web) traffic. \; <h5>Clicking displays the mean datagram size graph.</h5>');   K    alamToolTipAdd('dgramHist','System network interface (NI) average size \ E of datagram (the bytes during the interval divided by the number of \ ? datagrams). Transmitted displayed in green, received in blue. \ K <h5>Clicking displays the Web server average block size per second.</h5>');   M    alamToolTipAdd('blockHist','Server average size of read and write blocks \ B (the bytes during the interval divided by the number of blocks). \A Data blocks written is displayed in green, blocks read in blue. \ 6 <h5>Clicking displays the NI bytes per second.</h5>');      alamToolTipAdd('scriptHist', > 'Server script requests processed, where green is the total, \A blue the number of persistent scripts (CGIplus and RTE) and red \ " the number of CGI (heavyweight). \7 <h5>Clicking displays the system process graph.</h5>');        alamToolTipAdd('processHist',I 'Process counts, where green is system total and blue is WASD server(s) \ 9 plus current scripting processes (both DCL and DECnet). \ 9 <h5>Clicking displays the server scripting graph.</h5>');       alamToolTipAdd('otherHist',B 'Server requests processed <i>other</i> than the files, scripts, \, and proxy requests (reported separately).');      alamToolTipAdd('proxyHist',F 'Server proxy requests processed, where green is the total, blue the \? number read from cache, and red the number written to cache.');        alamToolTipAdd('requestHist',I 'Server requests processed, where green is the total and red the number \ < with a non-success status (zero, 4<i>nn<i> and 5<i>nn<i>). \6 <h5>Clicking displays the HTTP protocol graph.</h5>');      alamToolTipAdd('httpHist', + 'HTTP protocol, where green is the total, \ $ blue the number of HTTP/2 requests \1 and red the number of HTTP/1.<i>n</i> requests. \ 0 <h5>Clicking displays the request graph.</h5>');    %    alamToolTipAdd('scriptHistCREPRC', N 'DCL process creation and deletion.  All scripting that is not DECnet based. \B Green line is process creation.  Blue line is process deletion.');  %    alamToolTipAdd('scriptHistDECnet', D 'DECnet scripting.  Green line is all DECnet scripts (CGI + OSU).  \6 Blue line is CGI scripts.  Red line is OSU scripts.');  )    alamToolTipAdd('scriptHistCGIplusRTE', @ 'Persistent scripting.  Green line is total persistent scripts \: (RTE + CGIplus).  Blue line is reused script processes.');  !    alamToolTipAdd('throttleHist', H 'Throttled request processing, where green is the total under throttle \H control, blue the number initially queued, and red the number too busy \ (generating a 503 response).');       alamToolTipAdd('webdavHist', K 'WebDAV processing, where green is the total requests (read, write, lock, \ I prop, etc.), blue resources read, and red resources written (put, move, \  (copy, mkcol, etc.)'); }   
 ///////////// 
 // TOOLTIP // 
 /////////////   $ var alam_ToolTipArray = new Array(); var alam_ToolTipTimer = null,      alam_ToolTipCurrent = null;  var alam_ToolTipX = 0,     alam_ToolTipY = 0,     alam_ToolTipXguard = 20,     alam_ToolTipYguard = 10;     + // add an element's tip to the lookup array     function alamToolTipAdd (id,tip) {    if (tip.substr(0,1) == '[') F      alamToolTipSet(id,alam_ToolTipArray[tip.substr(1,tip.length-2)]);   else6      alamToolTipSet(id,(alam_ToolTipArray[id] = tip)); }   $ // set a tool tip against an element    function alamToolTipSet (id,tip) { 7    if (typeof tip == 'undefined') tip = '[' + id + ']';     var idobj = $byId(id);     if (!idobj)    {)       alert('TIP ' + id + ' undefined!'); 
       return;     }H    idobj.setAttribute('onmousemove','alamToolTip(event,"' + tip + '")');9    idobj.setAttribute('onmouseout','alamToolTip(event)');  }   4 // the mouse event on the element triggers a tooltip   function alamToolTip(evnt,tip) { .    if (!$byId("checkboxTips").checked) return;  3    var div = document.getElementById('divToolTip');     if (div == null)     {:       // create the div for the tooltip text just the once:       var body = document.getElementsByTagName('body')[0];.       var div = document.createElement('div');*       div.setAttribute('id','divToolTip');0       div.setAttribute('style','display:none;');5       // makes it easier on touch devices (e.g. iPad) ?       div.setAttribute('onclick','this.style.display="none";');        body.appendChild(div);    }       if (evnt.type == 'mousemove')    {!       alam_ToolTipX = evnt.pageX; !       alam_ToolTipY = evnt.pageY;   -       if (div && div.style.display == 'none')        { *          // tooltip is not (yet) displayed'          if (alam_ToolTipTimer) return;   /          // delay the appearance of the tooltip %          var callback = function(tip) 
          {7             // timeout for initial tooltip just expired %             alam_ToolTipTimer = null;   /             div.style.display = 'inline-block';   3             var pseudoEvent = { type : 'mousemove', 6                                 pageX : alam_ToolTipX,8                                 pageY : alam_ToolTipY };:             setTimeout(alamToolTip, 10, pseudoEvent, tip);  &             alam_ToolTipCurrent = tip;'             if (tip.substr(0,1) == '[') C                tip = alam_ToolTipArray[tip.substr(1,tip.length-2)]; B             document.getElementById('divToolTip').innerHTML = tip;          };   J          alam_ToolTipTimer = setTimeout(callback, alam_ToolTipDelay, tip);       } 
       else       { 8          // tooltip is currently displayed, just move it.          if (div.scrollWidth + alam_ToolTipX +4              alam_ToolTipXguard > window.innerWidth)J             div.style.left = (alam_ToolTipX - div.scrollWidth - 5) + 'px';
          else 8             div.style.left = (alam_ToolTipX + 5) + 'px';  /          if (div.scrollHeight + alam_ToolTipY + 5              alam_ToolTipYguard > window.innerHeight) J             div.style.top = (alam_ToolTipY - div.scrollHeight - 5) + 'px';
          else 7             div.style.top = (alam_ToolTipY + 5) + 'px';   (          if (tip != alam_ToolTipCurrent)
          {&             alam_ToolTipCurrent = tip;'             if (tip.substr(0,1) == '[') C                tip = alam_ToolTipArray[tip.substr(1,tip.length-2)];               div.innerHTML = tip;
          }  @          if (alam_ToolTipTimer) clearTimeout(alam_ToolTipTimer);"          alam_ToolTipTimer = null;       }     }    else     if (evnt.type == 'mouseout')     {=       // delay the disappearance of the tooltip just slightly #       var callback = function (tip)        { )          clearTimeout(alam_ToolTipTimer); "          alam_ToolTipTimer = null;$          div.style.display = 'none';       } &       clearTimeout(alam_ToolTipTimer);J       alam_ToolTipTimer = setTimeout(callback, alam_ToolTipOutDelay, tip);    }    else     {"       // tooltip no longer current&       clearTimeout(alam_ToolTipTimer);5       alam_ToolTipTimer = alam_ToolTipCurrent = null; !       div.style.display = 'none';     } }     O /*****************************************************************************/ 