O ///////////////////////////////////////////////////////////////////////////////  /**                                   graph.js  D Using Scalable Vector Graphics (SVG) generate the required graphics.    	 COPYRIGHT 	 --------- % Copyright (C) 2014-2018 Mark G.Daniel 0 This program, comes with ABSOLUTELY NO WARRANTY.G This is free software, and you are welcome to redistribute it under the N conditions of the GNU GENERAL PUBLIC LICENSE, version 3, or any later version.# http://www.gnu.org/licenses/gpl.txt      VERSION  ------- ; 11-APR-2015  MGD  bugfix; alamUsedBar() fixes for used plot 4                   alamUsedBar() exception for 'WSET'<                   Happy 62nd Wedding Anniversary Mum and Dad 05-FEB-2014  MGD  initial  */O ///////////////////////////////////////////////////////////////////////////////    function alamGraphSummary()  { 6    if (!(alam_StaticData && alam_SummaryData)) return;      alamDataAveMax ('bio');    alamDataAveMax ('cpuBusy');     alamDataAveMax ('deltaFile');!    alamDataAveMax ('deltaOther'); !    alamDataAveMax ('deltaProxy'); #    alamDataAveMax ('deltaRequest');      alamDataAveMax ('deltaHttp');!    alamDataAveMax ('deltaHttp1'); !    alamDataAveMax ('deltaHttp2'); "    alamDataAveMax ('deltaScript');#    alamDataAveMax ('nowThrottled'); %    alamDataAveMax ('deltaThrottled'); '    alamDataAveMax ('deltaWebDAVtotal');     alamDataAveMax ('fcpRW');     alamDataAveMax ('netPerSec');!    alamDataAveMax ('nowConnect');     alamDataAveMax ('sysProcs');      alamDataAveMax ('webPerSec');  "    alamDataAveMax ('deltaCREPRC');&    alamDataAveMax ('deltaCGIplusRTE');"    alamDataAveMax ('deltaDECnet');      alamSummaryData();     alamDisplaySynopsis();   =    alamBarGraph ('cpuBar', 'CPU', 'cpuBusy', null, 'cpuSEK'); )    alamBarGraph ('bioBar', 'BIO', 'bio'); ?    alamBarGraph ('diskBar', 'DISK', 'fcpRW', null, 'fcpWrite'); ?    alamBarGraph ('processBar', 'PROC', 'sysProcs', 'webProcs'); <    alamBarGraph ('netBar', 'NET', 'netPerSec', 'webPerSec');C    alamBarGraph ('connectBar', 'CONN', 'nowConnect', 'nowProcess'); <    alamBarGraph ('requestBar', 'REQU', 'deltaRequest', null,;                                        'deltaRequestFail'); >    alamBarGraph ('httpBar', 'HTTP', 'deltaHttp', 'deltaHttp2',2                                     'deltaHttp1');A    alamBarGraph ('fileBar', 'FILE', 'deltaFile', 'deltaFile304'); I    alamBarGraph ('scriptBar', 'SCRIPT', 'deltaScript', 'deltaCGIplusRTE', :                                         'deltaScriptCGI');G    alamBarGraph ('proxyBar', 'PROXY', 'deltaProxy', 'deltaProxyCache'); ;    alamBarGraph ('webdavBar', 'WEBDAV', 'deltaWebDAVtotal', O                                         'deltaWebDAVread', 'deltaWebDAVwrite'); 4    alamBarGraph ('otherBar', 'OTHER', 'deltaOther');N    alamBarGraph ('throttleBar', 'THROT', 'nowThrottled', 'nowThrottleQueued');  A    alamHistoryGraph('cpuHist', 'CPU', 'cpuBusy', null, 'cpuSEK'); -    alamHistoryGraph('bioHist', 'BIO', 'bio'); C    alamHistoryGraph('diskHist', 'DISK', 'fcpRW', null, 'fcpWrite');   >    alamHistoryGraph('throttleHist', 'THROT', 'deltaThrottled',@                     'deltaThrottleQueued', 'deltaThrottleBusy');E    alamHistoryGraph('fileHist', 'FILE', 'deltaFile', 'deltaFile304');   G    alamHistoryGraph('netHist', 'NET \u21b7', 'netPerSec', 'webPerSec'); M    alamHistoryGraph('dgramHist', 'DGRAM \u21b7', 'netDgramTx', 'netDgramRx'); S    alamHistoryGraph('blockHist', 'SERVER \u21b7', 'webBlockWrite', 'webBlockRead');   ?    alamHistoryGraph('webdavHist', 'WEBDAV', 'deltaWebDAVtotal', >                                             'deltaWebDAVread',@                                             'deltaWebDAVwrite');G    alamHistoryGraph('connectHist', 'CONN', 'nowConnect', 'nowProcess'); 2    alamHistoryGraph('scriptHist', 'SCRIPT \u21b7',H                     'deltaScript', 'deltaCGIplusRTE', 'deltaScriptCGI');J    alamHistoryGraph('processHist', 'PROC \u21b7', 'sysProcs', 'webProcs');  )    alamHistoryGraph('proxyHist', 'PROXY', H                     'deltaProxy', 'deltaProxyCache', 'deltaProxyWrite');1    alamHistoryGraph('requestHist', 'REQU \u21b7', >                     'deltaRequest', null, 'deltaRequestFail');.    alamHistoryGraph('httpHist', 'HTTP \u21b7',=                     'deltaHttp', 'deltaHttp2', 'deltaHttp1'); 8    alamHistoryGraph('otherHist', 'OTHER', 'deltaOther');  /    alamHistoryGraph ('scriptHistCREPRC', 'DCL', 3                      'deltaCREPRC', 'deltaDELPRC'); 7    alamHistoryGraph ('scriptHistCGIplusRTE', 'SCRIPT+', A                      'deltaCGIplusRTE', 'deltaCGIplusRTEreused'); 2    alamHistoryGraph ('scriptHistDECnet', 'DECnet',H                      'deltaDECnet', 'deltaDECnetCGI', 'deltaDECnetOSU'); }   O ///////////////////////////////////////////////////////////////////////////////   ) var alam_HistoryHeight = alam_HistHeight, (     alam_HistoryWidth = alam_HistWidth5;  & function alamSetHistoryWidth (seconds) { /    alamCSS ('.history', 'width', seconds+'px');     alam_HistoryWidth = seconds;     alamStoreSeconds (seconds); }   O ///////////////////////////////////////////////////////////////////////////////  /*H Scan all data in the (dynamic) DataStore for the given datum.  Calculate> maximum and average values and store in the respective arrays. */   var alam_DataAverage = [],     alam_DataMaximum = [];   function alamDataAveMax (datum)  {     var val,         ave = 0,         cnt = 0,         len = alamStoreSize()-1,         max = 0; &    for (var idx = 0; idx < len; idx++)    {       cnt++;(       val = alamGetData(datum,null,idx);       ave += val;        if (val > max) max = val;     }0    if (cnt) alam_DataAverage[datum] = ave / cnt;!    alam_DataMaximum[datum] = max;  }   O ///////////////////////////////////////////////////////////////////////////////  /*2 Generate the instantaneous data display bar graph.  N The function parameters can take one to three additional arguments.  These areL the names of each of the data.  The first is plotted in green, the second in= blue, the third in red.  Any may be omitted except the first.  */   var alam_BarClass = [];   alam_BarClass [1] = 'bar_green'; alam_BarClass [2] = 'bar_blue';  alam_BarClass [3] = 'bar_red';  " function alamBarGraph (name,title) {      if (!alamStoreSize()) return;  )    var ave, dcnt, max, plot, string, val;     var datum = [];      var id = $byId(name);  1    // datum has [1]..[n] from arguments [2]..[n]  B    for (dcnt = 1; dcnt <= 3 && dcnt <= arguments.length-2; dcnt++)&       datum[dcnt] = arguments[dcnt+1];      ///////////////////    // special cases //    ///////////////////      if (name == 'cpuBar')    {/       var cpuActive = alamGetData('cpuActive');        if (cpuActive > 1)       {           max = 100 * cpuActive; $          title = 'CPUx' + cpuActive;       } 
       else          max = 100; '       ave = alam_DataAverage[datum[1]];     }    else     if (name == 'netBar')    {K       /* web can exceed net throughput if in-system (non-NIC) connection */ B       if (alam_DataMaximum[datum[1]] > alam_DataMaximum[datum[2]])*          max = alam_DataMaximum[datum[1]];
       else*          max = alam_DataMaximum[datum[2]];'       ave = alam_DataAverage[datum[1]];     }    else     {'       max = alam_DataMaximum[datum[1]]; '       ave = alam_DataAverage[datum[1]];     }      ///////////////////    // generate bars //    ///////////////////  M    var svg = '<svg width="' + alam_BarWidth + '" height="' + alam_BarHeight + 5              '" xmlns="http://www.w3.org/2000/svg"' + . ' xmlns:xlink="http://www.w3.org/1999/xlink" \" style="pointer-events:none;"><g>';      string = alamValue(max); =    svg += '<text x="' + (alam_BarWidth-(string.length*7)-5) + <           '" y="12" class="bar_text">' + string + '</text>';      if (ave)     {       if (ave < 0) ave = 0;        if (ave > max) ave = max;        plot = 0; 0       if (max) plot = ave / max * alam_BarWidth;  <       svg += '<rect x="0" y="0" height="' + alam_BarHeight +8              '" width="' + plot + '" class="bar_ave"/>';$       if (plot > alam_BarLabelWidth)       { !          string = alamValue(ave); :          svg += '<text x="' + (plot-(string.length*7)-5) +B                 '" y="12" class="bar_text">' + string + '</text>';       }     }  $    for (dcnt = 1; dcnt <= 3; dcnt++)    {!       if (!datum[dcnt]) continue;   %       val = alamGetData(datum[dcnt]);        if (val < 0) val = 0;        if (val > max) val = max;        plot = 0; 0       if (max) plot = val / max * alam_BarWidth;  <       svg += '<rect x="0" y="0" height="' + alam_BarHeight +E              '" width="' + plot + '" class="' + alam_BarClass[dcnt] +               '"/>'; $       if (plot > alam_BarLabelWidth)       { !          string = alamValue(val); :          svg += '<text x="' + (plot-(string.length*7)-5) +B                 '" y="12" class="bar_text">' + string + '</text>';       }     }  E    svg += '<text x="5" y="12" class="bar_text">' + title + '</text>';       svg += '</g></svg>';       id.innerHTML = svg; }   O ///////////////////////////////////////////////////////////////////////////////  /*. Generate and display the history (line) graph.  N The function parameters can take one to three additional arguments.  These areL the names of each of the data.  The first is plotted in green, the second in= blue, the third in red.  Any may be omitted except the first.  */   var alam_HistoryClass = []; 9 alam_HistoryClass [1] = ['hist_green','hist_text_green']; 7 alam_HistoryClass [2] = ['hist_blue','hist_text_blue']; 5 alam_HistoryClass [3] = ['hist_red','hist_text_red'];   & function alamHistoryGraph (name,title) {      if (!alamStoreSize()) return;  ;    var ave, dcnt, dscnt, lastXnone, max, string, tcnt, val;     var datum = [],        points = [],         valdcnt = [];     var xpos = alam_HistoryWidth,$        lastXpos = alam_HistoryWidth;      var id = $byId(name);  1    // datum has [1]..[n] from arguments [2]..[n]  B    for (dcnt = 1; dcnt <= 3 && dcnt <= arguments.length-2; dcnt++)    {&       datum[dcnt] = arguments[dcnt+1];       points[dcnt] = '';    }  +    var interval = alam_StaticData.interval; ,    var timestamp = alamGetData('timestamp');      ///////////////////    // special cases //    ///////////////////      if (name == 'cpuHist')     {/       var cpuActive = alamGetData('cpuActive');        if (cpuActive > 1)       {           max = 100 * cpuActive; $          title = 'CPUx' + cpuActive;       } 
       else          max = 100; '       ave = alam_DataAverage[datum[1]];     }    else     if (name == 'netHist' ||         name == 'dgramHist' ||         name == 'blockHist')     {/       /* either can be larger than the other */ 8       if (alamGetData(datum[1]) > alamGetData(datum[2]))       { "          alamDataAveMax(datum[1]);*          max = alam_DataMaximum[datum[1]];*          ave = alam_DataAverage[datum[1]];       } 
       else       { "          alamDataAveMax(datum[2]);*          max = alam_DataMaximum[datum[2]];*          ave = alam_DataAverage[datum[2]];       }     }    else     {'       max = alam_DataMaximum[datum[1]]; '       ave = alam_DataAverage[datum[1]];     }      //////////////////////////     // generate data points //     //////////////////////////   1    var svg = '<svg width="' + alam_HistoryWidth + 0              '" height="' + alam_HistoryHeight +' '" xmlns="http://www.w3.org/2000/svg" \ , xmlns:xlink="http://www.w3.org/1999/xlink" \" style="pointer-events:none;"><g>';      dscnt = lastXnone = 0;   4    for (var idx = alamStoreSize()-1; idx > 0; idx--)    {       dscnt++;  ?       var step = timestamp - alamGetData('timestamp',null,idx); $       if ((xpos -= step) < 0) break;4       timestamp = alamGetData('timestamp',null,idx);  =       // paper-over reasonable data gaps from XHR re-requests =       var gapInterval = $WebSocket ? interval*3 : interval*5;          if (step > gapInterval)        {           ///////////////          // data loss //          ///////////////  K          svg += '<path d="M' + (lastXpos-1) + ',0 L' + (lastXpos-1) + ',' + >                 alam_HistoryHeight + '" class="hist_gap1"/>' +C                 '<path d="M' + (xpos+1) + ',0 L' + (xpos+1) + ',' + =                 alam_HistoryHeight + '" class="hist_gap2"/>';        }          //////////       // data //       //////////  ,       // for each of the three possible data'       for (dcnt = 1; dcnt <= 3; dcnt++)        { $          if (!datum[dcnt]) continue;            var cmd = ' L';$          if (!points[dcnt].length ||"              step > gapInterval ||#              lastXnone) cmd = ' M';   1          val = alamGetData(datum[dcnt],null,idx);           if (max) >             val = (alam_HistoryHeight / max * val).toFixed(0);
          else              val = 0;  G          points[dcnt] += cmd + xpos + ',' + (alam_HistoryHeight - val);             valdcnt[dcnt] = val;        }          lastXpos = xpos;       lastXnone = 0;    }      //////////////////     // plot average //     //////////////////       if (dscnt > 10)    {       if (ave > 1)       {           var aveplot = 0;           if (max) L             aveplot = alam_HistoryHeight - (alam_HistoryHeight / max * ave);K          svg += '<path d="M0,' + aveplot + ' L' + alam_HistoryWidth + ',' + 2                  aveplot + '" class="hist_ave"/>';  ?          if (aveplot > 15 && aveplot < alam_HistoryHeight - 15) 7             svg += '<text x="5" y="' + (aveplot + 12) + K                    '" class="hist_text_ave">' + alamValue(ave) + '</text>';        }     }      //////////////////////     // plot decorations //     //////////////////////   M    // if least recent data not plotted then draw virtual edge for stored data     if (lastXpos > interval * 2) H       svg += '<path d="M' + (lastXpos-1) + ',0 L' + (lastXpos-1) + ',' +:              alam_HistoryHeight + '" class="hist_gap0"/>';  )    // minute graduations along the X axis :    for (xpos = alam_HistoryWidth-60; xpos > 0; xpos -= 60)>        svg += '<path d="M' + xpos + ',' + alam_HistoryHeight +:               ' L' + xpos + ',' + (alam_HistoryHeight-5) +&               '" class="hist_grad"/>';      ///////////////    // plot data //    ///////////////      string = alamValue(max); C    svg += '<text x="' + (alam_HistoryWidth - (string.length*7)-5) + =           '" y="12" class="hist_text">' + string + '</text>';       tcnt = 0;$    for (dcnt = 1; dcnt <= 3; dcnt++)    {!       if (!datum[dcnt]) continue; 
       tcnt++;        if (points[dcnt].length):          svg += '<path d="' + points[dcnt] + '" class="' +3                 alam_HistoryClass[dcnt][0] + '"/>';   +       if ((val = alamGetData(datum[dcnt])))        { !          string = alamValue(val); G          svg += '<text x="' + (alam_HistoryWidth-(string.length*7)-5) + 8                 '" y="' + (12+(15*tcnt)) + '" class="' +G                 alam_HistoryClass[dcnt][1] + '">' + string + '</text>';        }     }      ////////////////////     // title of graph //     ////////////////////       title = title.split('\n'); I    svg += '<text x="5" y="12" class="hist_text">' + title[0] + '</text>'; &    if (typeof title[1] != 'undefined')L       svg += '<text x="5" y="24" class="hist_text">' + title[1] + '</text>';&    if (typeof title[2] != 'undefined')P       svg += '<text x="5" y="36" class="hist_text_red">' + title[2] + '</text>';      svg += '</g></svg>';       id.innerHTML = svg; }   O ///////////////////////////////////////////////////////////////////////////////  /*8 Generate the instantaneous instance process quota graph. */  - function alamUsedBar (name,title,avail,limit)  {     var id = $byId(name);  M    var svg = '<svg width="' + alam_BarWidth + '" height="' + alam_BarHeight + 5              '" xmlns="http://www.w3.org/2000/svg"' + . ' xmlns:xlink="http://www.w3.org/1999/xlink" \" style="pointer-events:none;"><g>';      var used = limit - avail;    if (used < 0) used = 0;"    if (used > limit) used = limit;!    var  usedplot = alam_BarWidth; 6    if (avail) usedplot = used / limit * alam_BarWidth;      var percent = 100; 8    if (avail) percent = (used * 100 / limit).toFixed(0);    var cssClass = 'used_bar'; ;    if (percent >= alam_UsedAlertPercent && title != 'WSET')        cssClass += '_alert';     percent += '%'   :    svg += '<rect x="0" y="0" height="' + alam_BarHeight + B           '" width="' + usedplot + '" class="' + cssClass + '"/>';  1    var string = alamWithCommas(limit.toString()); =    svg += '<text x="' + (alam_BarWidth-(string.length*7)-5) + <           '" y="12" class="bar_text">' + string + '</text>';  1    svg += '<text x="' + (70-(percent.length*7)) + =           '" y="12" class="bar_text">' + percent + '</text>';   E    svg += '<text x="5" y="12" class="bar_text">' + title + '</text>';       svg += '</g></svg>';       id.innerHTML = svg; }   O ///////////////////////////////////////////////////////////////////////////////  /*M Return a string respresenting the value paramater transmogrified to kilos and - megas as seem more meaningful.  Kilo == 1024!  */   function alamValue (value) { #    // useful during development :-) /    if (typeof value == 'undefined') return '?';       var fixed = 0;     if (value > 1099511627776)     {$       if (value > 1099511627776*100)          fixed = 1; 
       else#       if (value > 1099511627776*10)           fixed = 2; 
       else          fixed = 3; M       var string = ((value/1099511627776).toFixed(fixed)-0).toString() + 'T';     }    else     if (value > 1073741824)    {!       if (value > 1073741824*100)           fixed = 1; 
       else        if (value > 1073741824*10)          fixed = 2; 
       else          fixed = 3; J       var string = ((value/1073741824).toFixed(fixed)-0).toString() + 'G';    }    else     if (value > 1048576)     {       if (value > 1048576*100)          fixed = 1; 
       else       if (value > 1048576*10)           fixed = 2; 
       else          fixed = 3; G       var string = ((value/1048576).toFixed(fixed)-0).toString() + 'M';     }    else     if (value > 1024*10)     {'       if (value <= 1024*100) fixed = 1; D       var string = ((value/1024).toFixed(fixed)-0).toString() + 'k';    }    else $       var string = value.toFixed(0);      return string;  }   O ///////////////////////////////////////////////////////////////////////////////    function alamWithCommas(num) { N    return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, alam_ThousandComma); }   O /////////////////////////////////////////////////////////////////////////////// 