///////////////////////////////////////////////////////////////////////////////
/*
                                 display.js

COPYRIGHT
---------
Copyright (C) 2014-2018 Mark G.Daniel
This program, comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it under the
conditions of the GNU GENERAL PUBLIC LICENSE, version 3, or any later version.
http://www.gnu.org/licenses/gpl.txt


VERSION
-------
03-MAR-2018  MGD  incorporate (instance) status report
10-APR-2016  MGD  incorporate HTTP/2 and WASD v11.0
10-APR-2015  MGD  alamInstanceData() add buffered and direct IO counts
                  bugfix; alamUsedBar() WSET calculation
05-FEB-2014  MGD  initial
*/

///////////////////////////////////////////////////////////////////////////////
/*
*/

var alam_InsightTimeStamp = -1,
    alam_PrevInstanceStartup = 0;

function alamEscapeHTML(text)
{
   var chr = { '"': '&quot', '&': '&amp;', '<': '&lt;', '>': '&gt;' };
   function ent(ch) { return chr[ch]; }
   return text.replace(/[\"&<>]/g, ent);
}

function alamDisplayInsight (data)
{
   var ins = $byId('insight');
   var stamp = new Date();
   stamp = stamp.getTime() / 1000;
   if (stamp - alam_InsightTimeStamp >= 1) {
      var  html = '';
      html = 'WebSocket (re)connections: ' + acmeIpcCount() + '\n';
      html += 'alamode.EXE PID: ' + alam_StaticData.jpiPID + '\n';
      html += 'Store size: ' + alamStoreSize() + '\n';
      html += JSON.stringify(alam_StaticData,null,3);
      ins.innerHTML = html;
      alam_InsightTimeStamp = stamp;
      ins.setAttribute('ondblclick', 'alamInsightClick()');
   }
   ins.innerHTML += '\n' + alamEscapeHTML(JSON.stringify(data,null,3));
   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamSummaryDatum (datum,requests)
{
   var value = alamGetData(datum);
   return alamWithCommas(value) + alamSpacedPercent(value,requests);
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamStatusValue (code,requests)
{
   var value = alamGetData().statusCodes[code];
   return alamWithCommas(value) + alamSpacedPercent(value,requests);
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamSummaryData ()
{
   if (!alam_SummaryData) return;

   $byId('sumNodeName').innerHTML = alam_StaticData.nodeName;
   $byId('sumNodeName').setAttribute('onclick', 'alamInsightClick()');
   var sumService = location.hostname;
   if (location.port.length) sumService += ':' + location.port;
   $byId('sumService').innerHTML = sumService;
   $byId('sumVMStime').innerHTML = alamGetData('vmsTime'); 

   var html = '';

   if (alam_MsgFontSize)
      html += '<span style="color:red;">' + alam_MsgFontSize + '</span><br>';

   html += alam_StaticData.hwName + ' with ' + alam_StaticData.cpuAvail +
          (alam_StaticData.cpuAvail > 1 ? ' CPUs and ' : ' CPU and ') +
          alamValue(alam_StaticData.memSize) +
          'B, running VMS ' + alam_StaticData.vmsVersion +
          '.&nbsp; WASD v' + alam_StaticData.WASD +
          ' and <nobr><span class=\'alamode\'>&agrave; la mode</span> v' +
          alam_StaticData.alamode;

   html += '</nobr>.&nbsp; System up ' + alamGetData('upTime');
   html += '.&nbsp; Instance startup ' + alamGetData('instanceStartup'); 
   var instanceNodeCount = alamGetData('instanceNode');
   var instanceClusterCount = alamGetData('instanceCluster');
   if (instanceNodeCount > 1)
   {
      html += '.&nbsp; ' + instanceNodeCount + ' node instances';
      if (alamGetData('instancePassive'))
         html += ', 1 ACTIVE and ' + (instanceNodeCount-1) + ' PASSIVE';
   }
   if (instanceClusterCount > instanceNodeCount)
      html += ' and ' + instanceClusterCount + ' cluster instances';
   if (alamGetData('connectSuspend'))
      html += '.&nbsp; <span style="color:red;">Network connects SUSPENDED</span>';
   html += '.&nbsp; Collecting for ' + alamCollectFor() + '.';
   $byId('sumSystem').innerHTML = html;

   var requests = alamGetData('totalRequest');
   var connected = alamGetData('totalConnect');

   $byId('sumConnectCurrent').innerHTML = alamWithCommas(alamGetData('nowConnect'));
   $byId('sumConnectPeak').innerHTML = alamWithCommas(alamGetData('peakConnect'));
   $byId('sumConnectTotal').innerHTML = alamWithCommas(alamGetData('totalConnect'));

   $byId('sumProcessCurrent').innerHTML = alamWithCommas(alamGetData('nowProcess'));
   $byId('sumProcessPeak').innerHTML = alamWithCommas(alamGetData('peakProcess'));
   $byId('sumProcessTotal').innerHTML = alamWithCommas(alamGetData('totalRequest'));

   $byId('sumBytesRx').innerHTML = alamValue(alamGetData('bytesRx')) + 'B';

   $byId('sumHTTP2connect').innerHTML = alamWithCommas(alamGetData('nowHttp2Connect'));
   $byId('sumHTTP2process').innerHTML = alamWithCommas(alamGetData('nowHttp2Process'));
   $byId('sumHTTP2total').innerHTML = alamWithCommas(alamGetData('totalHttp2Process'));
   $byId('sumHTTP2percent').innerHTML = alamParenPercent(alamGetData('totalHttp2Process'),requests);

   $byId('sumHTTP1connect').innerHTML = alamWithCommas(alamGetData('nowHttp1Connect'));
   $byId('sumHTTP1process').innerHTML = alamWithCommas(alamGetData('nowHttp1Process'));
   $byId('sumHTTP1total').innerHTML = alamWithCommas(alamGetData('totalHttp1Process'));
   $byId('sumHTTP1percent').innerHTML = alamParenPercent(alamGetData('totalHttp1Process'),requests);

   $byId('sumSSL').innerHTML = alamSummaryDatum('totalSSL',requests);
   $byId('sumBytesTx').innerHTML = alamValue(alamGetData('bytesTx')) + 'B';

   $byId('sumFile').innerHTML = alamSummaryDatum('totalFile',requests);
   $byId('sumOther').innerHTML = alamSummaryDatum('totalOther',requests);
   $byId('sumProxy').innerHTML = alamSummaryDatum('totalProxy',requests);
   $byId('sumScript').innerHTML = alamSummaryDatum('totalScript',requests);
   $byId('sumWebDAV').innerHTML = alamSummaryDatum('totalWebDAV',requests);

   $byId('sumThrottleProcessed').innerHTML =
         alamSummaryDatum('totalThrottled',requests);
   $byId('sumThrottleQueued').innerHTML =
         alamSummaryDatum('totalThrottleQueued',requests);
   $byId('sumThrottleBusy').innerHTML =
         alamSummaryDatum('totalThrottleBusy',requests);

   $byId('nn1').innerHTML = alamStatusValue(1,requests);
   $byId('nn2').innerHTML = alamStatusValue(2,requests);
   $byId('nn3').innerHTML = alamStatusValue(3,requests);
   $byId('nn4').innerHTML = alamStatusValue(4,requests);
   $byId('nn5').innerHTML = alamStatusValue(5,requests);

   var instanceStartup = alamGetData('instanceStartup'); 
   if (alam_PrevInstanceStartup)
      if (instanceStartup > alam_PrevInstanceStartup)
         alamAlert(alamGetData('vmsTime'),'!Instance startup increased from ' +
                   alam_PrevInstanceStartup + ' to ' + instanceStartup);
      else
      if (instanceStartup < alam_PrevInstanceStartup)
         alamAlert(alamGetData('vmsTime'),
                   '!Instance startup <u>decreased</u> from ' +
                   alam_PrevInstanceStartup + ' to ' + instanceStartup);
   alam_PrevInstanceStartup = instanceStartup;

   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////

function alamDisplaySynopsis ()
{
   if (!alam_SummaryData) return;
   if (!alam_SynopsisDisplay) return;

   $byId('closedNodeName').innerHTML = alam_StaticData.nodeName;
   $byId('closedService').innerHTML = location.hostname + location.port;
   $byId('closedVMStime').innerHTML = alamGetData('vmsTime');

   var html = ' &nbsp;&ndash;&nbsp; ';
   html += 'cnct:' +  alamGetData('nowConnect') +
           '&nbsp;&nbsp;(' + alamGetData('peakConnect') + ')&nbsp;&nbsp;';
   html += 'proc:' +  alamGetData('nowProcess') +
           '&nbsp;&nbsp;(' + alamGetData('peakProcess') + ')&nbsp;&nbsp;';
   var requests = alamGetData('totalRequest');
   html += '1nn:' + alamGetData().statusCodes[1] + '&nbsp;&nbsp;';
   html += '2nn:' + alamGetData().statusCodes[2] + '&nbsp;&nbsp;';
   html += '3nn:' + alamGetData().statusCodes[3] + '&nbsp;&nbsp;';
   html += '4nn:' + alamGetData().statusCodes[4] + '&nbsp;&nbsp;';
   html += '5nn:' + alamGetData().statusCodes[5];
   $byId('closedSynopsis').innerHTML = html;
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamRequestData ()
{
   if (!alam_RequestData) return;

   $byId('reqTime').innerHTML = alam_RequestData.time;
   $byId('reqStatus').innerHTML = alam_RequestData.status;
   $byId('reqRx').innerHTML = alamWithCommas(alam_RequestData.rx);
   $byId('reqTx').innerHTML = alamWithCommas(alam_RequestData.tx);
   if (alam_RequestData.gzipTx)
      $byId('reqTx').innerHTML += '&nbsp;&nbsp;(' + alam_RequestData.gzipTx +
                                  '%)';
   $byId('reqDuration').innerHTML = 
         alam_RequestData.duration.replace(/(\.[0-9]*?)0+$/,'$1') +
         '&nbsp;&nbsp;(' + alamValue(alam_RequestData.bps) + 'Bps)';

   if (alam_RequestData.client && alam_RequestData.client.charAt(0) == '[')
      alam_RequestData.client = null;

   if (alam_RequestData.client)
      $byId('reqClient').innerHTML = alam_RequestData.client;
   else
      $byId('reqClient').innerHTML = alam_RequestData.clientIP;

   if (alam_RequestData.client && alam_RequestData.clientIP)
      $byId('reqClientIp').innerHTML =
        '&nbsp;' + '(' + alam_RequestData.clientIP + ')';
   else
      $byId('reqClientIp').innerHTML = '';

   if (alam_RequestData.geo)
      $byId('reqClientGeo').innerHTML =
         '&nbsp;' + utf8.decode(alam_RequestData.geo);
   else
      $byId('reqClientGeo').innerHTML = '';

   if (alam_RequestData.http)
      $byId('reqHttp').innerHTML = alam_RequestData.http;
   else
      $byId('reqHttp').innerHTML = '1.<i>n</>';

   if (alam_RequestData.user)
      $byId('reqUser').innerHTML = alam_RequestData.user;
   else
      $byId('reqUser').innerHTML = '<i>none</i>';

   $byId('reqService').innerHTML = alam_RequestData.service;
   if (alam_RequestData.prcnam.length)
      $byId('reqPrcNam').innerHTML = '&nbsp;&nbsp;(' +
                                     alam_RequestData.prcnam + ')';
   else
      $byId('reqPrcNam').innerHTML = null;
   $byId('reqRequest').innerHTML = alam_RequestData.method + '&nbsp;' +
                                   alam_RequestData.uri.substr(0,118) + '\n' +
                                   alam_RequestData.uri.substr(118);

   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamScriptData ()
{
   $byId('scriptNow').innerHTML =
         alamGetDataWithCommas('scriptNow',alam_ScriptData);

   $byId('scriptCGIplusNow').innerHTML =
        alamGetDataWithCommas('scriptCGIplusNow',alam_ScriptData);

   $byId('scriptRTENow').innerHTML =
        alamGetDataWithCommas('scriptRTENow',alam_ScriptData);

   $byId('scriptHardLimit').innerHTML =
         alamGetDataWithCommas('scriptHardLimit',alam_ScriptData);

   $byId('scriptCGIplus').innerHTML =
         alamGetDataWithCommas('totalCGIplus',alam_ScriptData) +  '&nbsp;&nbsp;(' +
         alamGetDataWithCommas('totalCGIplusReused',alam_ScriptData) + ')';

   $byId('scriptRTE').innerHTML =
         alamGetDataWithCommas('totalRTE',alam_ScriptData) +  '&nbsp;&nbsp;(' +
         alamGetDataWithCommas('totalRTEreused',alam_ScriptData) + ')';

   $byId('scriptCGI').innerHTML =
        alamGetDataWithCommas('totalCGI',alam_ScriptData);
   $byId('scriptCLI').innerHTML =
        alamGetDataWithCommas('totalCLI',alam_ScriptData);

   $byId('scriptDECnetNow').innerHTML =
         alamGetDataWithCommas('DECnetNow',alam_ScriptData);

   $byId('scriptDECnetCGInow').innerHTML =
         alamGetDataWithCommas('DECnetCGINow',alam_ScriptData);

   $byId('scriptDECnetOSUnow').innerHTML =
         alamGetDataWithCommas('DECnetOSUNow',alam_ScriptData);

   $byId('scriptDECnetTotal').innerHTML =
         alamGetDataWithCommas('doDECnet',alam_DetailData);

   $byId('scriptDECnetCGI').innerHTML =
         alamGetDataWithCommas('totalDECnetCGI',alam_ScriptData);

   $byId('scriptDECnetOSU').innerHTML =
         alamGetDataWithCommas('totalDECnetOSU',alam_ScriptData);

   $byId('webSocketNow').innerHTML =
         alamGetDataWithCommas('nowWebSocket');
   $byId('webSocketTotal').innerHTML =
         alamGetDataWithCommas('totalWebSocket');
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamProxyData ()
{
   if (alam_StaticData.proxyEnabled)
      $byId('proxyEnabled').innerHTML = 'enabled';
   else
      $byId('proxyEnabled').innerHTML = 'disabled';

   if (!alam_ProxyData) return;

   var proxyTotal = alamGetData('total',alam_ProxyData);

   var proxyNetwork = alamGetData('network',alam_ProxyData);
   $byId('proxyNetwork').innerHTML = alamWithCommas(proxyNetwork);

   var netRx = alamGetData('networkRx',alam_ProxyData);
   var netTx = alamGetData('networkTx',alam_ProxyData);

   $byId('proxyNetworkRx').innerHTML = alamValue(netRx);
   $byId('proxyNetworkTx').innerHTML = alamValue(netTx);

   $byId('proxyLookupDNS').innerHTML =
         alamWithCommas(alamGetData('lookupDNS',alam_ProxyData));
   $byId('proxyLookupCache').innerHTML =
         alamWithCommas(alamGetData('lookupCache',alam_ProxyData));
   $byId('proxyLookupLiteral').innerHTML =
         alamWithCommas(alamGetData('lookupLiteral',alam_ProxyData));
   $byId('proxyLookupError').innerHTML =
         alamWithCommas(alamGetData('lookupError',alam_ProxyData));

   $byId('proxyTunnelNow').innerHTML =
         alamWithCommas(alamGetData('tunnelNow',alam_ProxyData));
   $byId('proxyTunnel').innerHTML =
         alamWithCommas(alamGetData('tunnel',alam_ProxyData));

   $byId('proxySocks5Count').innerHTML =
         alamWithCommas(alamGetData('socks5Count',alam_ProxyData));
   $byId('proxySocks5Success').innerHTML =
         alamWithCommas(alamGetData('socks5Success',alam_ProxyData));
   $byId('proxySocks5Fail').innerHTML =
         alamWithCommas(alamGetData('socks5Fail',alam_ProxyData));

   $byId('proxyReworkCount').innerHTML =
         alamWithCommas(alamGetData('reworkCount',alam_ProxyData));
   $byId('proxyReworkNoType').innerHTML =
         alamWithCommas(alamGetData('reworkNoType',alam_ProxyData));
   $byId('proxyReworkReplaceCount').innerHTML =
         alamWithCommas(alamGetData('reworkReplaceCount',alam_ProxyData));
   $byId('proxyReworkReplaceSearch').innerHTML =
         alamWithCommas(alamGetData('reworkReplaceSearch',alam_ProxyData));
   $byId('proxyReworkTooBig').innerHTML =
         alamWithCommas(alamGetData('reworkTooBig',alam_ProxyData));

   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
Instance status report.
*/

function alamStatusData ()
{
   var  len, html;

   if (!alam_StatusData) return;

   html = '<tr style=\"white-space:nowrap;\"><th></th>\
<th class="talft">Instance</th><th>Ago</th>\
<th class="talft pdlft">Up</th><th>Ago</th><th>Count</th>\
<th class="talft pdlft">Exit</th>\
<th>Ago</th><th class="talft">Status</th>\
<th class="pdlft">Version</th><th>/Min</th><th>/Hour</th></tr>\n';

   if (len = alam_StatusData.instance.length)
   {
      for (idx = 0; idx < len; idx++)
      {
         item = alam_StatusData.instance[idx];
         if (item[0] == 0)
            html += '<tr style="text-decoration:line-through;"><th></th>';
         else
            html += '<tr><th>' + item[0] + '</th>';
         html += '<td class="talft">' + item[1] + '</td>';
         html += '<td>' + item[2] + '</td>';
         html += '<td class="talft pdlft">' + item[3] + '</td>';
         html += '<td>' + item[4] + '</td>';
         html += '<td>' + item[5] + '</td>';
         html += '<td class="talft pdlft">' + item[6] + '</td>';
         html += '<td>' + item[7] + '</td>';
         html += '<td class="talft">' + item[8] + '</td>';
         html += '<td class="pdlft">' + item[9] + '</td>';
         html += '<td>' + item[10] + '</td>';
         html += '<td>' + item[11] + '</td>';
         html += '</tr>\n';
      }
   }
   else
      html += '<tr><th>0</th><td class="talft">reset?</td>\n';

   $byId('statusTab').innerHTML = html;

   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamWebDavData ()
{
   var total, value;
   var netRx = alamGetData('bytesRx');
   var netTx = alamGetData('bytesTx');
   var netRxTx = netRx + netTx;
   var davRx = alamGetData('bytesRawRx',alam_WebDavData);
   var davTx = alamGetData('bytesRawTx',alam_WebDavData);
   var davRxTx = davRx + davTx;

   var enabled = '<i>disabled</i>';
   if (alam_StaticData.webdavEnabled) enabled = 'enabled';
   $byId('webdavEnabled').innerHTML = enabled;

   $byId('webdavRx').innerHTML =
         alamValue(davRx) + alamSpacedPercent(davRx,netRx);
   $byId('webdavTx').innerHTML =
         alamValue(davTx) + alamSpacedPercent(davTx,netTx);
   $byId('webdavRxTx').innerHTML =
         alamValue(davRxTx) + alamSpacedPercent(davRxTx,netRxTx);

   total = alamGetData('total',alam_WebDavData);
   value = alamGetData('totalRead',alam_WebDavData);
   $byId('webdavRead').innerHTML =
        alamWithCommas(value) + alamSpacedPercent(value,total);
   value = alamGetData('totalWrite',alam_WebDavData);
   $byId('webdavWrite').innerHTML =
        alamWithCommas(value) + alamSpacedPercent(value,total);
   value = alamGetData('totalLock',alam_WebDavData);
   $byId('webdavLock').innerHTML =
        alamWithCommas(value) + alamSpacedPercent(value,total);
   value = alamGetData('totalOther',alam_WebDavData);
   $byId('webdavOther').innerHTML =
        alamWithCommas(value) + alamSpacedPercent(value,total);
   $byId('webdavTotal').innerHTML = alamWithCommas(total);

   $byId('webdavModule').innerHTML =
        alamGetDataWithCommas('module',alam_WebDavData);
   $byId('webdavXMLparse').innerHTML =
        alamGetDataWithCommas('parseXML',alam_WebDavData);
   $byId('webdavMetaRead').innerHTML =
        alamGetDataWithCommas('metaRead',alam_WebDavData);
   $byId('webdavMetaReadAttempt').innerHTML =
        alamGetDataWithCommas('metaReadAttempt',alam_WebDavData);
   $byId('webdavMetaWrite').innerHTML =
        alamGetDataWithCommas('metaWrite',alam_WebDavData);
   $byId('webdavMetaWriteAttempt').innerHTML =
        alamGetDataWithCommas('metaWriteAttempt',alam_WebDavData);
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamDetailDatum (datum,requests)
{
   var value = alamGetData(datum,alam_DetailData);
   return alamWithCommas(value) + ' &nbsp;' + alamParenPercent(value,requests);
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamDetailData ()
{
   if (!alam_DetailData) return;

   var requests = alamGetData('totalRequest');

   $byId('methCONNECT').innerHTML = alamDetailDatum('methConnect',requests);
   $byId('methCOPY').innerHTML = alamDetailDatum('methCopy',requests);
   $byId('methDELETE').innerHTML = alamDetailDatum('methDelete',requests); 
   $byId('methGET').innerHTML = alamDetailDatum('methGet',requests); 
   $byId('methHEAD').innerHTML = alamDetailDatum('methHead',requests);
   $byId('methLOCK').innerHTML = alamDetailDatum('methLock',requests);
   $byId('methMKCOL').innerHTML = alamDetailDatum('methMkCol',requests);
   $byId('methMOVE').innerHTML = alamDetailDatum('methMove',requests);
   $byId('methOPTIONS').innerHTML = alamDetailDatum('methOptions',requests);
   $byId('methPOST').innerHTML = alamDetailDatum('methPost',requests);
   $byId('methPROPFIND').innerHTML = alamDetailDatum('methPropFind',requests);
   $byId('methPROPPATCH').innerHTML = alamDetailDatum('methPropPatch',requests);
   $byId('methPUT').innerHTML = alamDetailDatum('methPut',requests);
   $byId('methTRACE').innerHTML = alamDetailDatum('methTrace',requests);
   $byId('methUNLOCK').innerHTML = alamDetailDatum('methUnlock',requests);

   $byId('doAdmin').innerHTML = alamDetailDatum('doAdmin',requests);
   $byId('doDCL').innerHTML = alamDetailDatum('doDclScript',requests);
   $byId('doDECnet').innerHTML = alamDetailDatum('doDECnet',requests);
   $byId('doDir').innerHTML = alamDetailDatum('doDir',requests);
   $byId('doFile').innerHTML = alamDetailDatum('doFile',requests);
   $byId('doProxy').innerHTML = alamDetailDatum('doProxy',requests);
   $byId('doPut').innerHTML = alamDetailDatum('doPut',requests);
   $byId('doSSI').innerHTML = alamDetailDatum('doSSI',requests);
   $byId('doWebDAV').innerHTML = alamDetailDatum('doWebDAV',requests);
   $byId('doNoModule').innerHTML = alamDetailDatum('doNoModule',requests);

   var value = alamGetData('totalWebSocket');
   $byId('doWebSock').innerHTML = alamWithCommas(value) + ' &nbsp;' +
                                  alamParenPercent(value,requests);

   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamInstanceData ()
{
   if (!alam_InstanceData) return;

   var html = '';
   for (var idx = 0; idx < alam_InstanceData.instance.length; idx++)
   {
      html += '<div id="instanceData">&nbsp;<b>' +
              alam_InstanceData.instance[idx].pid +
              '&nbsp;&nbsp;' +
              alam_InstanceData.instance[idx].prcnam +
              '</b>&nbsp;&nbsp;Up:&nbsp;' +
              alam_InstanceData.instance[idx].conTime +
              '</b>&nbsp;&nbsp;CPU:&nbsp;' +
              alam_InstanceData.instance[idx].cpuTime +
              '&nbsp;&nbsp' +
              alam_InstanceData.instance[idx].state;
      if (alam_InstanceData.instance[idx].cpuid >= 0)
         html += '&nbsp;&nbsp;CPU#' + alam_InstanceData.instance[idx].cpuid;
      html += '&nbsp;&nbsp' + alam_InstanceData.instance[idx].astFlags;
      html += '&nbsp;&nbsp;BIO:&nbsp;' + alam_InstanceData.instance[idx].bufio;
      html += '&nbsp;&nbsp;DIO:&nbsp;' + alam_InstanceData.instance[idx].dirio;
      if (alam_InstanceData.instance[idx].pageFaults)
         html += '&nbsp;&nbsp;PGFLT:&nbsp;' +
                 alam_InstanceData.instance[idx].pageFaults;

      if (alamGetData('instancePassive'))
      {
         if (alam_InstanceData.instance[idx].pid ==
             alamGetData('instanceNodeSuper'))
            html += '&nbsp;&nbsp;Instance:&nbsp;ACTIVE';
         else
            html += '&nbsp;&nbsp;Instance:&nbsp;PASSIVE';
      }
      else
      if (alam_InstanceData.instance[idx].pid ==
          alamGetData('instanceNodeSuper'))
         html += '&nbsp;&nbsp;Instance:&nbsp;SUPERVISOR';
       
      html += '</div>';
      html += '<div id="instAST' + idx + '" class="usedBar"></div>';
      html += '<div id="instBIO' + idx + '" class="usedBar"></div>';
      html += '<div id="instBYT' + idx + '" class="usedBar"></div>';
      html += '<div id="instDIO' + idx + '" class="usedBar"></div>';
      html += '<div id="instENQ' + idx + '" class="usedBar"></div>';
      html += '<div id="instFIL' + idx + '" class="usedBar"></div>';
      html += '<div id="instPGFL' + idx + '" class="usedBar"></div>';
      html += '<div id="instTQ' + idx + '" class="usedBar"></div>';
      html += '<div id="instWSET' + idx + '" class="usedBar"></div>';
   }
   $byId('instanceDiv').innerHTML = html;

   for (var idx = 0; idx < alam_InstanceData.instance.length; idx++)
   {
      alamUsedBar('instAST'+idx,'ASTLM',alam_InstanceData.instance[idx].astcnt,
                                        alam_InstanceData.instance[idx].astlm);
      alamUsedBar('instBIO'+idx,'BIOLM',alam_InstanceData.instance[idx].biocnt,
                                        alam_InstanceData.instance[idx].biolm);
      alamUsedBar('instBYT'+idx,'BYTLM',alam_InstanceData.instance[idx].bytcnt,
                                        alam_InstanceData.instance[idx].bytlm);
      alamUsedBar('instDIO'+idx,'DIOLM',alam_InstanceData.instance[idx].diocnt,
                                        alam_InstanceData.instance[idx].diolm);
      alamUsedBar('instENQ'+idx,'ENQLM',alam_InstanceData.instance[idx].enqcnt,
                                        alam_InstanceData.instance[idx].enqlm);
      alamUsedBar('instFIL'+idx,'FILLM',alam_InstanceData.instance[idx].filcnt,
                                        alam_InstanceData.instance[idx].fillm);
      alamUsedBar('instPGFL'+idx,'PGFL',
                  alam_InstanceData.instance[idx].pagfilcnt,
                  alam_InstanceData.instance[idx].pgflquota)
      alamUsedBar('instTQ'+idx,'TQLM',alam_InstanceData.instance[idx].tqcnt,
                                       alam_InstanceData.instance[idx].tqlm);
      var wscnt = alam_InstanceData.instance[idx].wsextent -
                  (alam_InstanceData.instance[idx].ppgcnt +
                   alam_InstanceData.instance[idx].gpgcnt);
      alamUsedBar('instWSET'+idx,'WSET',
                  wscnt, alam_InstanceData.instance[idx].wsextent);
   }

   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
Return how long alamode has been collecting for.
*/

var alam_CollectLastFor = '',
    alam_CollectStartTime = new Date();

function alamCollectFor (zero)
{
   if (typeof zero != 'undefined' && zero) alam_CollectStartTime = new Date();
   if (!alam_CollectDisplay) return alam_CollectLastFor;

   var now = new Date();
   var then = alam_CollectStartTime;
   var diff = (Math.abs((now.getTime() - then.getTime()) / 1000)).toFixed(0);
   var secs = Math.floor(diff % 60).toFixed(0);
   diff /= 60;
   var mins = Math.floor(diff % 60).toFixed(0);
   diff /= 60;
   var hours = Math.floor(diff % 24).toFixed(0);
   diff /= 24;
   var days = Math.floor(diff).toFixed(0);
   if (hours < 10) hours = '0' + hours;
   if (mins < 10) mins = '0' + mins;
   if (secs < 10) secs = '0' + secs;
   alam_CollectLastFor = '';
   if (parseInt(days) > 0) alam_CollectLastFor = days + ' ';
   alam_CollectLastFor += hours + ':' + mins + ':' + secs;
   return alam_CollectLastFor;
}

///////////////////////////////////////////////////////////////////////////////
