///////////////////////////////////////////////////////////////////////////////
/*
                                  build.js

COPYRIGHT
---------
Copyright (C) 2014-2018 Mark G.Daniel
This program, comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it under the
conditions of the GNU GENERAL PUBLIC LICENSE, version 3, or any later version.
http://www.gnu.org/licenses/gpl.txt


VERSION
-------
29-OCT-2018  MGD  alamQueryConfig()
03-MAR-2018  MGD  add (instance) status
18-APR-2015  MGD  bugfix; alamConfigUrl() protocol and host and munge '+'
14-APR-2015  MGD  bugfix; alamConfigCollectClick() FRAME idx from 1
08-APR-2015  MGD  bugfix; alamBuildAlamode() lose the location.port (per AMc)
05-FEB-2014  MGD  initial
*/
///////////////////////////////////////////////////////////////////////////////

var alam_AlertsDisplay = false,
    alam_CollectDisplay = false,
    alam_DetailDisplay = false,
    alam_HistoryDisplay = false,
    alam_InstanceDisplay = false,
    alam_InsightDisplay = false,
    alam_ProxyDisplay = false,
    alam_RequestDisplay = false,
    alam_ScriptDisplay = false,
    alam_StatusDisplay = false,
    alam_SynopsisDisplay = false,
    alam_TipsDisplay = false,
    alam_UpdateDisplay = false,
    alam_WebDavDisplay = false;

var alam_ThisFrame;

///////////////////////////////////////////////////////////////////////////////
/*
If the location hash is supplied it's assumed to be originating from an iframe.
*/

function alamBuildPage ()
{
   if (alamFromQuery('frame'))
   {
      /* an iframe (contained by the parent page) */
      if (acme_StandAlone)
      {
         alamCSS ('#configAnchor','color','#000000');
         alamCSS ('#configControl','color','#000000');

         alamCSS ('body','background','transparent');
         alamCSS ('#monitor','background','transparent');
         alamCSS ('#monitor','border','none');
//         alamCSS ('#monitor','border','dotted 1px silver');
         alamCSS ('#monitor','box-shadow','none');
         alamCSS ('#monitor','padding','5px 15px 0 10px');
      }
      else
      {
         alamCSS ('#configAnchor','color','#ffffff');
         alamCSS ('#configControl','color','#ffffff');

         alamCSS ('body','background','transparent');
         alamCSS ('#configAnchor','color','#ffffff');
         alamCSS ('#configControl','color','#ffffff');
         alamCSS ('#monitor','border','1px outset white');
         alamCSS ('#monitor','box-shadow','1px 3px 5px 1px #505050');
         alamCSS ('#monitor','padding','10px');
      }
   }
   else
   {
      /* the fundamental parent page (contains the iframes) */
      if (acme_StandAlone)
      {
         alamCSS ('#configTitle','color','#ffffff');
         alamCSS ('#configTitle','text-shadow',
'0 1px 0 #ccc,\
0 2px 0 #c9c9c9,\
0 3px 0 #bbb,\
0 4px 0 #b9b9b9,\
0 5px 0 #aaa,\
0 6px 1px rgba(0,0,0,.1),\
0 0 5px rgba(0,0,0,.1),\
0 1px 3px rgba(0,0,0,.3),\
0 3px 5px rgba(0,0,0,.2),\
0 5px 10px rgba(0,0,0,.25),\
0 10px 10px rgba(0,0,0,.2),\
0 20px 20px rgba(0,0,0,.15)');
         alamCSS ('#configTitle','background-clip','text');

         /** http://www.colorzilla.com/gradient-editor/ **/
         alamCSS ('body','background','#eeeeee');
         alamCSS ('body','background',
'linear-gradient(135deg, #eeeeee 50%,#b8b8b8 100%)');
      }
      else
      {
         alamCSS ('#configTitle','background-clip','text');
         alamCSS ('#configTitle','text-shadow',
'0px 1px 2px rgba(255,255,255,.4), -1px -2px 0px rgba(0,0,0,.7)');

         /** http://www.colorzilla.com/gradient-editor/ **/
         alamCSS ('body','background','#b5bdc8;');
         alamCSS ('body','background',
'linear-gradient(135deg, #b5bdc8 0%,#929ca5 50%,#48545b 100%);');
      }
      alamCSS ('body','background-attachment','fixed');
   }

   window.addEventListener('message', acmePostedMessage, false);

   if (alamFromQuery('frame'))
      acmeLoadFile('monitor.html',alamBuildMonitor);
   else
      alamBuildAlamode();
}

///////////////////////////////////////////////////////////////////////////////
/*
Set runtime configuration from request query and/or MONDESI_QUERY string
elements.
*/

function alamQueryConfig ()
{
   if (!alam_StaticData) return setTimeout(alamQueryConfig,100);

   var yep = /^(x|X|1)$/;
   var  value;

   if (value = alamFromQuery('minutes'))
   {
      if (value == '5') alamMinutesClick(5);
      if (value == '15') alamMinutesClick(15);
   }
   if (value = alamFromQuery('alerts')) alamAlertsClick(value.match(yep));
   if (value = alamFromQuery('detail')) alamDetailClick(value.match(yep));
   if (value = alamFromQuery('instance')) alamInstanceClick(value.match(yep));
   if (value = alamFromQuery('history')) alamHistoryClick(value.match(yep));
   if (value = alamFromQuery('proxy')) alamProxyClick(value.match(yep));
   if (value = alamFromQuery('request')) alamRequestClick(value.match(yep));
   if (value = alamFromQuery('script')) alamScriptClick(value.match(yep));
   if (value = alamFromQuery('status')) alamStatusClick(value.match(yep));
   if (value = alamFromQuery('tips')) alamTipsClick(value.match(yep));
   if (value = alamFromQuery('webdav')) alamWebDavClick(value.match(yep));
}

///////////////////////////////////////////////////////////////////////////////
/*
Building the top-level main page.  Generate an iframe for each server to be
monitored.  When the iframe loads it calls acmeBuildIframeLoad() to check the
load success (or otherwise).
*/

function alamBuildAlamode ()
{
   // Opera (only?) wait for the document to materialise
   if (!document.body)
   {
      setTimeout('alamBuildAlamode()',250);
      return;
   }

   var nodes;
   if (!(nodes = alamFromQuery('nodes'))) 
      nodes = location.protocol + '//' + location.host + location.pathname;
   nodes = nodes.replace(/\n|\r\n|\r/g,'+');
   nodes = nodes.replace(/\+{2,}/g,'+');
   nodes = nodes.replace(/^\+/, '');
   nodes = nodes.replace(/^\+$/, '');
   var these = nodes.split('+');

   var html = '<div>\
\
<div id="configSection">\
\
<div id="configTick">\
<input type="checkbox" onclick="alamConfigClick()">\
</div>\
\
<div id="SECTION1" style="display:none;">\
\
<div id="configTitle">&agrave; la mode</div>\
<form id="configForm">\
<textarea id="configNodes" rows="5" cols="64">';

   for (var idx = 0; idx < these.length; idx++)
      html += these[idx] + '\n';

   html += '</textarea><p>\
<input type="button" class="configBtn" value="Monitor" \
onclick="window.location.replace(alamConfigUrl()';

   if (acme_StandAlone) html += '+\'&salone=1\'';

   html += ')">\
<input type="button" class="configBtn" value="Open" \
onclick="alamOpenalamode(alamConfigUrl()+\'&salone=1\')">\
<input type="button" class="configBtn" value="Link" \
onclick="alamLinkClick()">\
<input type="button" class="configBtn" value="Reset" \
onclick="$byId(\'configForm\').reset()">\
<input type="button" class="configBtn" value="Clear" \
onclick="$byId(\'configNodes\').value=\'\'">\
</form>\
<div id="configLink" style="display:none;"><a id="configAnchor"></a></div>\
\
<div id="configControl">';

   if (idx > 1)
      html += '<input type="checkbox" value="none" \
id="checkboxConfigCollect" class="controlCheckbox" style="margin-left:2em;" \
checked="checked" onchange="alamConfigCollectClick()">\
<label id="controlConfigCollect" \
for="checkboxConfigCollect">Collect All</label>';

   html += '</div>\
</div>\
</div>\
<div id="alamode" align="center">';

   for (var idx = 0; idx < these.length; idx++)
   {
      if (!these[idx].length) continue;
      var parts = these[idx].split('?');
      these[idx] = parts[0] + '?frame=' + (idx+1);
      if (location.search.substr(1).length)
         these[idx] += '&' + location.search.substr(1);
      if (acme_StandAlone) these[idx] += '&salone=1';
      if (parts.length > 1) these[idx] += '&' + parts[1];
      acmeIframeCheck(idx+1,these[idx]);
      html += '<iframe id="FRAME' + (idx+1) + '" scrolling="no" \
seamless="seamless" height="0" width="0" src="' + these[idx] + '" \
onload="acmeIframeCheck('+(idx+1)+')">\
</iframe>';
   }
   html += '</div>';

   document.body.innerHTML = html;
}

///////////////////////////////////////////////////////////////////////////////
/*
Send a message to each frame to open/close their WebSocket connection.  Can be
done semi-directly because the configuration panel resides in the top-level
page.
*/

function alamConfigCollectClick (checked)
{
   if (typeof checked == 'undefined')
      checked = $byId('checkboxConfigCollect').checked;
   for (var cnt = 0; true; cnt++)
   {
      var obj = $byId('FRAME'+(cnt+1));
      if (!obj) break;
      var json = '{"$ConfigCollect":true,"checked":' + checked + '}';
      obj.contentWindow.postMessage(json,'*');
   }
}

///////////////////////////////////////////////////////////////////////////////
/*
Send a message to each frame to open/close their WebSocket connection.  Can be
done semi-directly because the configuration panel resides in the top-level
page.
*/

function alamConfigUpdateClick (checked)
{
   if (typeof checked == 'undefined')
      checked = $byId('checkboxConfigUpdate').checked;
   for (var cnt = 0; true; cnt++)
   {
      var obj = $byId('FRAME'+cnt);
      if (!obj) break;
      var json = '{"$ConfigUpdate":true,"checked":' + checked + '}';
      obj.contentWindow.postMessage(json,'*');
   }
}

///////////////////////////////////////////////////////////////////////////////
/*
Build the monitor page in an iframe.
*/

function alamBuildMonitor (html)
{
   // tell the parent the frame has loaded successfully
   acmeIframeCheck(true);

   alam_ThisFrame = 'FRAME' + acmeFrameNumber();

   var body = document.getElementsByTagName('body')[0];
   body.innerHTML = html;
   alamBuildControl();
   alamSetHistoryWidth(alam_HistWidth5);
   alamCollectClick(true);
   alamAlertsClick(true);
   alamUpdateClick(true);
   alamMinutesClick(5);
   alamQueryConfig();

   acmeAdjustSize();

   acmeLoadFile('tips.js','alamToolTipInit()');
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamConfigClick ()
{
   var ticked = $byId('SECTION1');
   if (ticked.style.display == 'none')
      ticked.style.display = 'block'
   else
      ticked.style.display = 'none'
   if (acme_StandAlone) acmeFitWindow();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamMonitorClick (obj)
{
   var closed = $byId('monitorClosed');
   var open = $byId('monitorOpen');
   if (obj.checked)
   {
      closed.style.display = 'none';
      open.style.display = 'block';
      alam_SynopsisDisplay = false;
   }
   else
   {
      closed.style.display = 'block';
      $byId('closedAlert').innerHTML = '';
      open.style.display = 'none';
      alam_SynopsisDisplay = true;
      alamDisplaySynopsis();
   }
   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
Generate the URL, including the query string, used to open the top-level
monitor page.
*/

function alamConfigUrl ()
{
   var action = location.protocol + '//' + location.host + $ScriptName;
   var nodes = $byId('configNodes').value;
   nodes = nodes.replace(/\n|\r\n|\r/g,'+');
   nodes = nodes.replace(/\+{2,}/g,'+');
   nodes = nodes.replace(/^\+/, '');
   nodes = nodes.replace(/^\+$/, '');
   var url = action + '?nodes=' + encodeURIComponent(nodes);
   return url;
}

///////////////////////////////////////////////////////////////////////////////
/*
Open a standalone monitor.
*/

function alamOpenalamode (url)
{
   if (url)
      window.onerror = function (msg,url,lnum) { alert (msg+' '+url+' '+lnum) };
   else
   {
      if (!document.getElementById('configForm'))
      {
         alert(mdsLangBookmarklet);
         return false;
      }
   }

   var name = new Date();
   name = 'alamode_' + name.getTime();

   var specs = 'toolbar=0,location=0,directories=0,status=0,' +
               'menubar=0,scrollbars=1,resizable=0,copyhistory=0,' +
               'width=100,height=100';

   window.open((url?url:alamConfigUrl()),name,specs);

   return false;
}

///////////////////////////////////////////////////////////////////////////////
/*
Display a link capable of being put into a bookmark and used to directly open a
standalone monitor.
*/

function alamLinkClick (change)
{
   var cl = document.getElementById('configLink');
   if (!change)
   {
      if (cl.style.display == 'inline-block')
      {
         cl.style.display = 'none';
         return false;
      }
      cl.style.display = 'inline-block';
   }
   if (cl.style.display != 'inline-block') return false;

   var params = 'status=0,toolbar=0,location=0,menubar=0,resizable=0,' +
                'scrollbars=1,height=100,width=100';
   var href = 'javascript:void(window.open("' + alamConfigUrl() +
                               '&salone=1' + '","_blank","' + params + '"))';
   var title = 'alamode ' + $ExeVersion;

   var nodes = $byId('configNodes').value;
   if (nodes.length < 10)
      cl.style.display = 'none';
   else
   {
      var ca = $byId('configAnchor');
      ca.href = ca.innerHTML = href;
      cl.style.display = 'inline-block';
   }

   return false;
}

///////////////////////////////////////////////////////////////////////////////

////////////////////////
// control checkboxes //
////////////////////////

///////////////////////////////////////////////////////////////////////////////
/*
Generate the monitor control check boxes.
*/

function alamBuildControl ()
{
   var html = '';
   html += '<table id="controlTab"><tr>';

   html += '<td><input type="checkbox" value="none" id="checkboxCollect" \
class="controlCheckbox" onclick="alamCollectClick()">\
<label id="controlCollect" for="checkboxCollect">Collect</label></td>';

   html += '<td><input type="checkbox" value="none" id="checkboxUpdate" \
class="controlCheckbox" onclick="alamUpdateClick()">\
<label id="controlUpdate" for="checkboxUpdate">Update</label></td>';

   html += '<td><input type="checkbox" value="none" id="checkboxAlerts" \
class="controlCheckbox" onclick="alamAlertsClick()">\
<label id="controlAlerts" for="checkboxAlerts">Alerts</label></td>';

   html += '<td><input type="checkbox" value="none" id="checkboxTips" \
class="controlCheckbox" onclick="alamTipsClick()">\
<label id="controlTips" for="checkboxTips">Tips</label></td>';

   html += '<td><input type="checkbox" value="none" id="checkboxHistory" \
class="controlCheckbox" onclick="alamHistoryClick()">\
<label id="controlHistory" for="checkboxHistory">History</label></td>';

   html += '<td colspan="2"><input type="checkbox" value="none" id="checkboxMinutes" \
class="controlCheckbox" onclick="alamMinutesClick()">\
<label id="controlMinutes" for="checkboxMinutes">5 Minutes</label></td>';

   html += '<td style="width:50%;text-align:right;">\
<input id="zeroBtn" type="button" class="button" \
value="Zero" onclick="alamZeroClick();return false;">&nbsp;\
<input id="printBtn" type="button" class="button" \
value="Print" onclick="setTimeout(\'window.print()\',100);return false;">\
</td>';

   html += '</tr><tr>';

   html += '<td><input type="checkbox" value="none" id="checkboxDetail" \
class="controlCheckbox" onclick="alamDetailClick()">\
<label id="controlDetail" for="checkboxDetail">Detail</label></td>';

   html += '<td><input type="checkbox" value="none" id="checkboxInstance" \
class="controlCheckbox" onclick="alamInstanceClick()">\
<label id="controlInstance" for="checkboxInstance">Instance</label></td>';

   html += '<td><input type="checkbox" value="none" id="checkboxProxy" \
class="controlCheckbox" onclick="alamProxyClick()" disabled="disabled">\
<label id="controlProxy" for="checkboxProxy">Proxy</label></td>';

   html += '<td><input type="checkbox" value="none" id="checkboxRequest" \
class="controlCheckbox" onclick="alamRequestClick()">\
<label id="controlRequest" for="checkboxRequest">Request</label></td>';

   html += '<td><input type="checkbox" value="none" id="checkboxScript" \
class="controlCheckbox" onclick="alamScriptClick()">\
<label id="controlScript" for="checkboxScript">Script</label></td>';

   html += '<td><input type="checkbox" value="none" id="checkboxStatus" \
class="controlCheckbox" onclick="alamStatusClick()" disabled="disabled">\
<label id="controlStatus" for="checkboxStatus">Status</label></td>';

   html += '<td><input type="checkbox" value="none" id="checkboxWebDav" \
class="controlCheckbox" onclick="alamWebDavClick()" disabled="disabled">\
<label id="controlWebDav" for="checkboxWebDav">WebDAV</label></td>';

   html += '</tr></table>';
   $byId('control').innerHTML = html;
}

///////////////////////////////////////////////////////////////////////////////
/*
The dollar prefixed version is called from acmePostedMessage().
*/

function $CollectClick (state) { alamCollectClick(state) };

function alamCollectClick (state)
{
   var cbx = $byId('checkboxCollect');

   if (typeof state == 'undefined') state = !alam_CollectDisplay;
   alam_CollectDisplay = cbx.checked = state;

   if (alam_CollectDisplay)
      alamStreamData(true);
   else
   {
      alamStreamData(false);
      alamOnClose(true);
   }
}

///////////////////////////////////////////////////////////////////////////////
/*
Tips checkbox has been clicked.
*/

function alamTipsClick (state)
{
   var cbx = $byId('checkboxTips');
   if (typeof state == 'undefined') state = !alam_TipsDisplay;
   alam_TipsDisplay = cbx.checked = state;
}

///////////////////////////////////////////////////////////////////////////////
/*
The dollar prefixed version is called from acmePostedMessage().
*/

function $UpdateClick (state) { alamUpdateClick(state) };

function alamUpdateClick (state)
{
   var cbx = $byId('checkboxUpdate');
   if (typeof state != 'undefined') alam_UpdateDisplay = !state;
   if (alam_UpdateDisplay)
   {
      alam_UpdateDisplay = false;
      cbx.checked = false;
   }
   else
   {
      alam_UpdateDisplay = true;
      cbx.checked = true;
   }
}

///////////////////////////////////////////////////////////////////////////////
/*
Alerts checkbox has been clicked.
*/

function alamAlertsClick (state)
{
   var cbx = $byId('checkboxAlerts');
   if (typeof state == 'undefined') state = !alam_AlertsDisplay;
   alam_AlertsDisplay = cbx.checked = state;
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamHistoryClick (state)
{
   var cbx = $byId('checkboxHistory');
   var htab = $byId('historyDiv');

   if (typeof state == 'undefined') state = !alam_HistoryDisplay;
   alam_HistoryDisplay = cbx.checked = state;

   if (alam_HistoryDisplay)
      htab.style.display = 'block';
   else
      htab.style.display = 'none';

   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamMinutesClick (mins)
{
   var cbx = $byId('checkboxMinutes');
   var label = $byId('controlMinutes');

   if ((typeof mins != 'undefined' && mins == 5) ||
       alam_HistoryWidth == alam_HistWidth15)
   {
      alamSetHistoryWidth(alam_HistWidth5);
      cbx.checked = true;
      label.innerHTML = '5 Minutes'
   }
   else
   {
      alamSetHistoryWidth(alam_HistWidth15);
      cbx.checked = true;
      label.innerHTML = '15 Minutes'
   }
   alamGraphSummary();
   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamProxyClick (state)
{
   var cbx = $byId('checkboxProxy');
   var tab = $byId('proxyTab');

   if (typeof state == 'undefined') state = !alam_ProxyDisplay;
   alam_ProxyDisplay = cbx.checked = state;

   if (alam_ProxyDisplay)
   {
      if ($WebSocket)
         acmeIpcSend('proxy=1');
      else
         alamProxyData();
      tab.style.display = 'block';
   }
   else
   {
      if ($WebSocket) acmeIpcSend('proxy=0');
      alam_ProxyData = null;
      tab.style.display = 'none';
   }
   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamRequestClick (state)
{
   var cbx = $byId('checkboxRequest');
   var tab = $byId('requestTab');

   if (typeof state == 'undefined') state = !alam_RequestDisplay;
   alam_RequestDisplay = cbx.checked = state;

   if (alam_RequestDisplay)
   {
      if ($WebSocket)
         acmeIpcSend('request=1');
      else
         alamRequestData();
      tab.style.display = 'block';
   }
   else
   {
      if ($WebSocket) acmeIpcSend('request=0');
      alam_RequestData = null;
      tab.style.display = 'none';
   }
   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamDetailClick (state)
{
   var cbx = $byId('checkboxDetail');
   var tab = $byId('detailTab');

   if (typeof state == 'undefined') state = !alam_DetailDisplay;
   alam_DetailDisplay = cbx.checked = state;

   if (alam_DetailDisplay)
   {
      if ($WebSocket)
         acmeIpcSend('detail=1');
      else
         alamDetailData();
      tab.style.display = 'block';
   }
   else
   {
      if ($WebSocket) acmeIpcSend('detail=0');
      alam_DetailData = null;
      tab.style.display = 'none';
   }
   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamScriptClick (state)
{
   var cbx = $byId('checkboxScript');
   var tab = $byId('scriptTab');
   var hist = $byId('scriptHistory');

   if (typeof state == 'undefined') state = !alam_ScriptDisplay;
   alam_ScriptDisplay = cbx.checked = state;

   if (alam_ScriptDisplay)
   {
      if ($WebSocket)
         acmeIpcSend('script=1');
      else
         alamScriptData();
      tab.style.display = hist.style.display = 'block';
   }
   else
   {
      if ($WebSocket) acmeIpcSend('script=0');
      alam_ScriptData = null;
      tab.style.display = hist.style.display = 'none';
   }
   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamInstanceClick (state)
{
   var cbx = $byId('checkboxInstance');
   var div = $byId('instanceDiv');

   if (typeof state == 'undefined') state = !alam_InstanceDisplay;
   alam_InstanceDisplay = cbx.checked = state;

   if (alam_InstanceDisplay)
   {
      if ($WebSocket)
         acmeIpcSend('instance=1');
      else
         alamInstanceData();
      div.style.display = 'block';
   }
   else
   {
      if ($WebSocket) acmeIpcSend('instance=0');
      alam_InstanceData = null;
      div.style.display = 'none';
   }
   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamNetHistClick (that)
{
   if (that.id == 'netHist')
   {
      that.style.display = 'none';
      $byId('dgramHist').style.display = 'inline-block';
   }
   else
   if (that.id == 'dgramHist')
   {
      that.style.display = 'none';
      $byId('blockHist').style.display = 'inline-block';
   }
   else
   {
      that.style.display = 'none';
      $byId('netHist').style.display = 'inline-block';
   }
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamProcessClick (that)
{
   if (that.id == 'scriptHist')
   {
      that.style.display = 'none';
      $byId('processHist').style.display = 'inline-block';
   }
   else
   {
      that.style.display = 'none';
      $byId('scriptHist').style.display = 'inline-block';
   }
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamHttpClick (that)
{
   if (that.id == 'requestHist')
   {
      that.style.display = 'none';
      $byId('httpHist').style.display = 'inline-block';
   }
   else
   {
      that.style.display = 'none';
      $byId('requestHist').style.display = 'inline-block';
   }
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamStatusClick (state)
{
   var cbx = $byId('checkboxStatus');
   var tab = $byId('statusTab');

   if (typeof state == 'undefined') state = !alam_StatusDisplay;
   alam_StatusDisplay = cbx.checked = state;

   if (alam_StatusDisplay)
   {
      if ($WebSocket)
         acmeIpcSend('status=1');
      else
         alamStatusData();
      tab.style.display = 'block';
   }
   else
   {
      if ($WebSocket) acmeIpcSend('status=0');
      alam_StatusData = null;
      tab.style.display = 'none';
   }
   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
*/

function alamWebDavClick (state)
{
   var cbx = $byId('checkboxWebDav');
   var tab = $byId('webdavTab');

   if (typeof state == 'undefined') state = !alam_WebDavDisplay;
   alam_WebDavDisplay = cbx.checked = state;

   if (alam_WebDavDisplay)
   {
      if ($WebSocket)
         acmeIpcSend('webdav=1');
      else
         alamWebDavData();
      tab.style.display = 'block';
   }
   else
   {
      if ($WebSocket) acmeIpcSend('webdav=0');
      alam_WebDavData = null;
      tab.style.display = 'none';
   }
   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
Insight displays the raw JSON data as received from the script.
*/

function alamInsightClick ()
{
   var div = $byId('insight');
   if (alam_InsightDisplay)
   {
      alam_InsightDisplay = false;
      div.style.display = 'none';
   }
   else
   {
      alam_InsightDisplay = true;
      div.style.display = 'block';
   }
   acmeAdjustSize();
}

///////////////////////////////////////////////////////////////////////////////
/*
Tell alamode.EXE which non-default data items are currently required.  When a
WebSocket connection is broken for some reason, and then reestablished, this
function sends a message to the executable via the re-established WebSocket so
that the non-default data are generated and supplied.
*/

function alamTheseData ()
{
   var msg = '';
   if (alam_DetailDisplay)
   {
      if (msg.length) msg += '&';
      msg += 'detail=1';
   }
   if (alam_InstanceDisplay)
   {
      if (msg.length) msg += '&';
      msg += 'instance=1';
   }
   if (alam_ProxyDisplay)
   {
      if (msg.length) msg += '&';
      msg += 'proxy=1';
   }
   if (alam_RequestDisplay)
   {
      if (msg.length) msg += '&';
      msg += 'request=1';
   }
   if (alam_ScriptDisplay)
   {
      if (msg.length) msg += '&';
      msg += 'script=1';
   }
   if (alam_StatusDisplay)
   {
      if (msg.length) msg += '&';
      msg += 'status=1';
   }
   if (alam_WebDavDisplay)
   {
      if (msg.length) msg += '&';
      msg += 'webdav=1';
   }
   if (msg.length) acmeIpcSend(msg);
}

///////////////////////////////////////////////////////////////////////////////
